# Specs

Here you'll find specifications for custom elements and other library features.

> **Note:** When authoring a new spec, please use [our standard spec template](./template.md). Specs can be submitted in the form of a PR. Prior to creating a PR, be sure to remove any boilerplate from the spec template which was not used. The PR that introduces your spec should also add a link to this readme in the specs section below.

## Web Component Specifications
| Name | Spec | Component |
| :--------- | :---------: | ---------: |
| [Accordion](../packages/web-components/fast-foundation/src/accordion/accordion-spec.md) | :white_check_mark: | :white_check_mark: |
| Alert | -- | -- |
| [Anchored region](../packages/web-components/fast-foundation/src/anchored-region/anchored-region.spec.md) | :white_check_mark: | :white_check_mark: |
| [Avatar](./avatar.md) | :white_check_mark: | -- |
| [Badge](../packages/web-components/fast-foundation/src/badge/badge.spec.md) | :white_check_mark: | :white_check_mark: |
| [Breadcrumb](..packages/web-components/fast-foundation/src/breadcrumb./breadcrumb.spec.md) | :white_check_mark: | :white_check_mark: |
| [Card](../packages/web-components/fast-foundation/src/card/card.spec.md) | :white_check_mark: | :white_check_mark: |
| Carousel | -- | -- |
| [Checkbox](../packages/web-components/fast-foundation/src/checkbox/checkbox.spec.md) | :white_check_mark: | :white_check_mark: |
| Combobox | -- | :white_check_mark:  |
| [Data grid](../packages/web-components/fast-foundation/src/data-grid/data-grid.spec.md) | :white_check_mark: | :white_check_mark: |
| [Dialog](../packages/web-components/fast-foundation/src/dialog/dialog.spec.md) | :white_check_mark: | :white_check_mark: |
| [Disclosure](../packages/web-components/fast-foundation/src/disclosure/disclosure.spec.md) | :white_check_mark: | :white_check_mark: |
| [Flipper](../packages/web-components/fast-foundation/src/flipper/flipper.spec.md) | :white_check_mark: | :white_check_mark: |
| [Form associated custom elements](../packages/web-components/fast-foundation/src/form-associated/form-associated-custom-element.spec.md) | :white_check_mark: | :white_check_mark: |
| Horizontal scroll | -- | :white_check_mark:  |
| [Listbox](../packages/web-components/fast-foundation/src/listbox/listbox.spec.md) | :white_check_mark: | :white_check_mark: |
| [Menu](../packages/web-components/fast-foundation/src/menu/menu.md) | :white_check_mark: | :white_check_mark: |
| [Number field](../packages/web-components/fast-foundation/src/number-field/number-field.spec.md) | :white_check_mark: | :white_check_mark: |
| [Progress](../packages/web-components/fast-foundation/src/progress/progress.spec.md) | :white_check_mark: | :white_check_mark: |
| [Radio](../packages/web-components/fast-foundation/src/radio/radio.spec.md) | :white_check_mark: | :white_check_mark: |
| [Radio group](../packages/web-components/fast-foundation/src/radio-group/radio-group.spec.md) | :white_check_mark: | :white_check_mark: |
| Rating | -- | -- |
| [Select](../packages/web-components/fast-foundation/src/select/select.spec.md) | :white_check_mark: | -- |
| [Skeleton](../packages/web-components/fast-foundation/src/skeleton/skeleton.spec.md) | :white_check_mark: | :white_check_mark: |
| [Slider](../packages/web-components/fast-foundation/src/slider/slider.spec.md) | :white_check_mark: | :white_check_mark: |
| Spin button | -- | -- |
| [Switch](../packages/web-components/fast-foundation/src/switch/switch.spec.md) | :white_check_mark: | :white_check_mark: |
| [Tabs](../packages/web-components/fast-foundation/src/tabs/tabs.spec.md) | :white_check_mark: | :white_check_mark: |
| [Text area](../packages/web-components/fast-foundation/src/text-area/text-area.spec.md) | :white_check_mark: | :white_check_mark: |
| [Text field](../packages/web-components/fast-foundation/src/text-field/text-field.spec.md) | :white_check_mark: | :white_check_mark: |
| [Toolbar](./toolbar.md) | :white_check_mark: | -- |
| [Tooltip](../packages/web-components/fast-foundation/src/tooltip/tooltip.spec.md) | :white_check_mark: | :white_check_mark: |
| [Tree view](../packages/web-components/fast-foundation/src/tree-view/tree-view.spec.md) | :white_check_mark: | :white_check_mark: |
| [Typography](./typography/typography.md) | :white_check_mark: | -- |
