#!/bin/bash

################################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $4 $6/mof/OpenDRIM_BIOSRegisteredProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_BIOSRegisteredProfile provider module";
Name = "BIOS_OpenDRIM_BIOSRegisteredProfileModule";
Location = "cmpiBIOS_OpenDRIM_BIOSRegisteredProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_BIOSRegisteredProfile provider";
Name = "BIOS_OpenDRIM_BIOSRegisteredProfileProvider";
ProviderModuleName = "BIOS_OpenDRIM_BIOSRegisteredProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_BIOSRegisteredProfile provider capabilities";
ProviderModuleName = "BIOS_OpenDRIM_BIOSRegisteredProfileModule";
ProviderName = "BIOS_OpenDRIM_BIOSRegisteredProfileProvider";
ClassName = "OpenDRIM_BIOSRegisteredProfile";
ProviderType = {2};
Namespaces = {"$4"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstanceID", "RegisteredOrganization", "OtherRegisteredOrganization", "RegisteredName", "RegisteredVersion", "AdvertiseTypes", "AdvertiseTypeDescriptions"};
CapabilityID = "BIOS_OpenDRIM_BIOSRegisteredProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_BIOSRegisteredProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_BIOSRegisteredProfile]   
   provider: BIOS_OpenDRIM_BIOSRegisteredProfileProvider
   location: cmpiBIOS_OpenDRIM_BIOSRegisteredProfileProvider
   type: instance
   namespace: $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_BIOSRegisteredProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_BIOSRegisteredProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_BIOSRegisteredProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
