/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-input-with-guard.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#include "config.h"
#include "generate-input-with-guard.json-TestReplayInputs.h"

#if ENABLE(WEB_REPLAY)
#include "InternalNamespaceImplIncludeDummy.h"
#include <platform/ExternalNamespaceImplIncludeDummy.h>

namespace Test {
#if ENABLE(DUMMY_FEATURE)
GetCurrentTime::GetCurrentTime(double currentTime)
    : NondeterministicInput<GetCurrentTime>()
    , m_currentTime(currentTime)
{
}

GetCurrentTime::~GetCurrentTime()
{
}
#endif // ENABLE(DUMMY_FEATURE)

SetRandomSeed::SetRandomSeed(uint64_t randomSeed)
    : NondeterministicInput<SetRandomSeed>()
    , m_randomSeed(randomSeed)
{
}

SetRandomSeed::~SetRandomSeed()
{
}
} // namespace Test

namespace JSC {
#if ENABLE(DUMMY_FEATURE)
const AtomicString& InputTraits<Test::GetCurrentTime>::type()
{
    static NeverDestroyed<const AtomicString> type("GetCurrentTime", AtomicString::ConstructFromLiteral);
    return type;
}

void InputTraits<Test::GetCurrentTime>::encode(EncodedValue& encodedValue, const Test::GetCurrentTime& input)
{
    encodedValue.put<double>(ASCIILiteral("currentTime"), input.currentTime());
}

bool InputTraits<Test::GetCurrentTime>::decode(EncodedValue& encodedValue, std::unique_ptr<Test::GetCurrentTime>& input)
{
    double currentTime;
    if (!encodedValue.get<double>(ASCIILiteral("currentTime"), currentTime))
        return false;

    input = std::make_unique<Test::GetCurrentTime>(currentTime);
    return true;
}
#endif // ENABLE(DUMMY_FEATURE)

const AtomicString& InputTraits<Test::SetRandomSeed>::type()
{
    static NeverDestroyed<const AtomicString> type("SetRandomSeed", AtomicString::ConstructFromLiteral);
    return type;
}

void InputTraits<Test::SetRandomSeed>::encode(EncodedValue& encodedValue, const Test::SetRandomSeed& input)
{
    encodedValue.put<uint64_t>(ASCIILiteral("randomSeed"), input.randomSeed());
}

bool InputTraits<Test::SetRandomSeed>::decode(EncodedValue& encodedValue, std::unique_ptr<Test::SetRandomSeed>& input)
{
    uint64_t randomSeed;
    if (!encodedValue.get<uint64_t>(ASCIILiteral("randomSeed"), randomSeed))
        return false;

    input = std::make_unique<Test::SetRandomSeed>(randomSeed);
    return true;
}

} // namespace JSC

#endif // ENABLE(WEB_REPLAY)
