# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 274-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53354);
 script_cve_id("CVE-2003-0167");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 274-2 (mutt)";
 script_name(name);

 desc = "The remote host is missing an update to mutt
announced via advisory DSA 274-2.

Byrial Jensen discovered a couple of off-by-one buffer overflow in the
IMAP code of Mutt, a text-oriented mail reader supporting IMAP, MIME,
GPG, PGP and threading.  This problem could potentially allow a remote
malicious IMAP server to cause a denial of service (crash) and
possibly execute arbitrary code via a specially crafted mail folder.

This advisory only covers the old stable distribution (potato) since
DSA 274-1 already fixed the stable distribution (woody).  For the old
stable distribution (potato) this problem has been fixed in version
1.2.5-5.2.

We recommend that you upgrade your mutt package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20274-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 274-2 (mutt)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mutt", ver:"1.2.5-5.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
