##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_evolution_data_server_mult_int_overflow_vuln.nasl 958 2009-03-16 18:50:29Z mar $
#
# Evolution Data Server Multiple Integer Overflow Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800254);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_bugtraq_id(34109, 34100);
  script_cve_id("CVE-2009-0582", "CVE-2009-0587");
  script_name("Evolution Data Server Multiple Integer Overflow Vulnerabilities");
  desc = "

  Overview: This host is installed with Evolution Data Server and is prone to
  multiple integer overflow vulnerabilities.

  Vulnerability Insight:
  - bug in Camel library while processing NTLM SASL packets.
  - bug in glib library while encoding and decoding Base64 data.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes
  through long string that is converted to a base64 representation and
  can cause a client crash via NTLM authentication type 2 packet with a
  length value that exceeds the amount of packet data.

  Affected Software/OS:
  Evolution Data Server version 2.24.5 and prior.
  Evolution Data Server version in range 2.25.x to 2.25.92

  Fix: Upgrade to latest version 2.26
  http://projects.gnome.org/evolution/download.shtml

  References:
  http://secunia.com/advisories/34286
  http://securitytracker.com/id?1021845
  http://openwall.com/lists/oss-security/2009/03/12/2
  http://mail.gnome.org/archives/release-team/2009-March/msg00096.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Evolution Data Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_evolution_data_server_detect.nasl");
  script_require_keys("Evolution/Ver");
  exit(0);
}


include("version_func.inc");

evolutionVer = get_kb_item("Evolution/Ver");
if(!evolutionVer){
  exit(0);
}

# Grep for vulnerable Evolution versions
if(version_in_range(version:evolutionVer, test_version:"2.25",
                                          test_version2:"2.25.92") ||
   version_is_less_equal(version:evolutionVer, test_version:"2.24.5")){
  security_warning(0);
}
