###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_nuke_userlog_sql_inj_vuln.nasl 2506 2009-06-01 12:09:29Z may $
#
# PHP-Nuke SQL Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900561);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1842");
  script_bugtraq_id(35117);
  script_name("PHP-Nuke SQL Injection Vulnerability");
  desc = "

  Overview: This host is running PHP-Nuke and is prone to SQL Injection
  vulnerability.

  Vulnerability Insight:
  The flaw is generated because the user supplied data passed into 'referer'
  header element when requesting the '/main/tracking/userLog.php' is not
  properly sanitized before it is used in an SQL query.

  Impact:
  Successful exploitation will let the attacker cause SQL Injection attack,
  gain sensitive information about the database used by the web application
  or can execute arbitrary code inside the context of the web application.

  Impact Level: Application

  Affected Software/OS:
  PHP-Nuke version 8.0 and prior on all platforms.

  Fix: Upgrade to version or later
  http://phpnuke-downloads.com/phpnuke.html

  References:
  http://www.securityfocus.com/archive/1/503845
  http://gsasec.blogspot.com/2009/05/php-nuke-v80-referer-sql-injection.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP-Nuke");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_php_nuke_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

nukePort = get_http_port(default:80);
if(!nukePort){
  exit(0);
}

nukeVer = get_kb_item("www/"+ nukePort + "/php-nuke");
if(!nukeVer){
  exit(0);
}

phpNukeVer = eregmatch(pattern:"^(.+) under (/.*)$", string:nukeVer);
if(phpNukeVer[1] != NULL)
{
  # Check for PHP-Nuke version 8.0 and prior
  if(version_is_less_equal(version:phpNukeVer[1], test_version:"8.0")){
    security_hole(nukePort);
  }
}
