/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.5
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "quvi"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "quvi"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION ""
#endif

enum enum_verbosity { verbosity__NULL = -1, verbosity_arg_debug = 0, verbosity_arg_verbose, verbosity_arg_quiet, verbosity_arg_mute };
enum enum_category { category__NULL = -1, category_arg_http = 0, category_arg_mms, category_arg_rtsp, category_arg_rtmp, category_arg_all };
enum enum_export_format { export_format__NULL = -1, export_format_arg_json = 0, export_format_arg_xml };
enum enum_export_level { export_level__NULL = -1, export_level_arg_media = 0, export_level_arg_PLUS_errors };
enum enum_feature { feature__NULL = -1, feature_arg_resolve = 0, feature_arg_MINUS_resolve, feature_arg_verify, feature_arg_MINUS_verify, feature_arg_proxy, feature_arg_MINUS_proxy };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *license_help; /**< @brief Print license and exit help description.  */
  const char *support_help; /**< @brief Print supported websites and exit help description.  */
  const char *query_formats_help; /**< @brief Query available formats to URL help description.  */
  char * agent_arg;	/**< @brief Identify as (default='Mozilla/5.0').  */
  char * agent_orig;	/**< @brief Identify as original value given at command line.  */
  const char *agent_help; /**< @brief Identify as help description.  */
  char * proxy_arg;	/**< @brief Use proxy with HTTP connections.  */
  char * proxy_orig;	/**< @brief Use proxy with HTTP connections original value given at command line.  */
  const char *proxy_help; /**< @brief Use proxy with HTTP connections help description.  */
  int connect_timeout_arg;	/**< @brief Seconds connecting allowed to take (default='30').  */
  char * connect_timeout_orig;	/**< @brief Seconds connecting allowed to take original value given at command line.  */
  const char *connect_timeout_help; /**< @brief Seconds connecting allowed to take help description.  */
  char ** exec_arg;	/**< @brief Execute command when done parsing.  */
  char ** exec_orig;	/**< @brief Execute command when done parsing original value given at command line.  */
  unsigned int exec_min; /**< @brief Execute command when done parsing's minimum occurreces */
  unsigned int exec_max; /**< @brief Execute command when done parsing's maximum occurreces */
  const char *exec_help; /**< @brief Execute command when done parsing help description.  */
  char * format_arg;	/**< @brief Query for format of media (default='default').  */
  char * format_orig;	/**< @brief Query for format of media original value given at command line.  */
  const char *format_help; /**< @brief Query for format of media help description.  */
  enum enum_verbosity verbosity_arg;	/**< @brief Verbosity level of printed messages (default='verbose').  */
  char * verbosity_orig;	/**< @brief Verbosity level of printed messages original value given at command line.  */
  const char *verbosity_help; /**< @brief Verbosity level of printed messages help description.  */
  enum enum_category *category_arg;	/**< @brief Level of libquvi scripts to enable (default='all').  */
  char ** category_orig;	/**< @brief Level of libquvi scripts to enable original value given at command line.  */
  unsigned int category_min; /**< @brief Level of libquvi scripts to enable's minimum occurreces */
  unsigned int category_max; /**< @brief Level of libquvi scripts to enable's maximum occurreces */
  const char *category_help; /**< @brief Level of libquvi scripts to enable help description.  */
  enum enum_export_format export_format_arg;	/**< @brief Export in data interchange format (default='json').  */
  char * export_format_orig;	/**< @brief Export in data interchange format original value given at command line.  */
  const char *export_format_help; /**< @brief Export in data interchange format help description.  */
  enum enum_export_level export_level_arg;	/**< @brief Level of exported data (default='media').  */
  char * export_level_orig;	/**< @brief Level of exported data original value given at command line.  */
  const char *export_level_help; /**< @brief Level of exported data help description.  */
  enum enum_feature *feature_arg;	/**< @brief Enable (or disable) feature.  */
  char ** feature_orig;	/**< @brief Enable (or disable) feature original value given at command line.  */
  unsigned int feature_min; /**< @brief Enable (or disable) feature's minimum occurreces */
  unsigned int feature_max; /**< @brief Enable (or disable) feature's maximum occurreces */
  const char *feature_help; /**< @brief Enable (or disable) feature help description.  */
  const char *category_all_help; /**< @brief All website script categories help description.  */
  const char *category_http_help; /**< @brief Category HTTP website scripts help description.  */
  const char *category_mms_help; /**< @brief Category MMS website scripts help description.  */
  const char *category_rtsp_help; /**< @brief Category RTSP website scripts help description.  */
  const char *category_rtmp_help; /**< @brief Category RTMP website scripts help description.  */
  const char *xml_help; /**< @brief Print details in XML help description.  */
  const char *quiet_help; /**< @brief Turn off output to stderr help description.  */
  const char *verbose_libcurl_help; /**< @brief Turn on libcurl verbose mode help description.  */
  const char *no_resolve_help; /**< @brief Do not resolve redirections help description.  */
  const char *no_verify_help; /**< @brief Do not verify media URL help description.  */
  const char *no_proxy_help; /**< @brief Disable use of HTTP proxy help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int license_given ;	/**< @brief Whether license was given.  */
  unsigned int support_given ;	/**< @brief Whether support was given.  */
  unsigned int query_formats_given ;	/**< @brief Whether query-formats was given.  */
  unsigned int agent_given ;	/**< @brief Whether agent was given.  */
  unsigned int proxy_given ;	/**< @brief Whether proxy was given.  */
  unsigned int connect_timeout_given ;	/**< @brief Whether connect-timeout was given.  */
  unsigned int exec_given ;	/**< @brief Whether exec was given.  */
  unsigned int format_given ;	/**< @brief Whether format was given.  */
  unsigned int verbosity_given ;	/**< @brief Whether verbosity was given.  */
  unsigned int category_given ;	/**< @brief Whether category was given.  */
  unsigned int export_format_given ;	/**< @brief Whether export-format was given.  */
  unsigned int export_level_given ;	/**< @brief Whether export-level was given.  */
  unsigned int feature_given ;	/**< @brief Whether feature was given.  */
  unsigned int category_all_given ;	/**< @brief Whether category-all was given.  */
  unsigned int category_http_given ;	/**< @brief Whether category-http was given.  */
  unsigned int category_mms_given ;	/**< @brief Whether category-mms was given.  */
  unsigned int category_rtsp_given ;	/**< @brief Whether category-rtsp was given.  */
  unsigned int category_rtmp_given ;	/**< @brief Whether category-rtmp was given.  */
  unsigned int xml_given ;	/**< @brief Whether xml was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int verbose_libcurl_given ;	/**< @brief Whether verbose-libcurl was given.  */
  unsigned int no_resolve_given ;	/**< @brief Whether no-resolve was given.  */
  unsigned int no_verify_given ;	/**< @brief Whether no-verify was given.  */
  unsigned int no_proxy_given ;	/**< @brief Whether no-proxy was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_verbosity_values[];  /**< @brief Possible values for verbosity. */
extern const char *cmdline_parser_category_values[];  /**< @brief Possible values for category. */
extern const char *cmdline_parser_export_format_values[];  /**< @brief Possible values for export-format. */
extern const char *cmdline_parser_export_level_values[];  /**< @brief Possible values for export-level. */
extern const char *cmdline_parser_feature_values[];  /**< @brief Possible values for feature. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
