% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateByTaxonomy.R
\name{aggregateByTaxonomy}
\alias{aggregateByTaxonomy}
\alias{aggTax}
\alias{aggTax}
\title{Aggregates a MRexperiment object or counts matrix to a particular level.}
\usage{
aggregateByTaxonomy(obj, lvl, alternate = FALSE, norm = FALSE,
  log = FALSE, aggfun = colSums, sl = 1000, featureOrder = NULL,
  returnFullHierarchy = TRUE, out = "MRexperiment")

aggTax(obj, lvl, alternate = FALSE, norm = FALSE, log = FALSE,
  aggfun = colSums, sl = 1000, featureOrder = NULL,
  returnFullHierarchy = TRUE, out = "MRexperiment")
}
\arguments{
\item{obj}{A MRexperiment object or count matrix.}

\item{lvl}{featureData column name from the MRexperiment object or if count matrix object a vector of labels.}

\item{alternate}{Use the rowname for undefined OTUs instead of aggregating to "no_match".}

\item{norm}{Whether to aggregate normalized counts or not.}

\item{log}{Whether or not to log2 transform the counts - if MRexperiment object.}

\item{aggfun}{Aggregation function.}

\item{sl}{scaling value, default is 1000.}

\item{featureOrder}{Hierarchy of levels in taxonomy as fData colnames}

\item{returnFullHierarchy}{Boolean value to indicate return single column of fData or all columns of hierarchy}

\item{out}{Either 'MRexperiment' or 'matrix'}
}
\value{
An aggregated count matrix.
}
\description{
Using the featureData information in the MRexperiment, calling aggregateByTaxonomy on a
MRexperiment and a particular featureData column (i.e. 'genus') will aggregate counts
to the desired level using the aggfun function (default colSums). Possible aggfun alternatives
include colMeans and colMedians.
}
\examples{

data(mouseData)
aggregateByTaxonomy(mouseData[1:100,],lvl="class",norm=TRUE,aggfun=colSums)
# not run
# aggregateByTaxonomy(mouseData,lvl="class",norm=TRUE,aggfun=colMedians)
# aggTax(mouseData,lvl='phylum',norm=FALSE,aggfun=colSums)

}
