% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeToGene.R
\docType{methods}
\name{summarizeToGene}
\alias{summarizeToGene}
\alias{summarizeToGene,list-method}
\title{Summarize estimated quantitites to gene-level}
\usage{
summarizeToGene(object, ...)

\S4method{summarizeToGene}{list}(object, tx2gene, varReduce = FALSE,
  ignoreTxVersion = FALSE, ignoreAfterBar = FALSE,
  countsFromAbundance = c("no", "scaledTPM", "lengthScaledTPM"))
}
\arguments{
\item{object}{the list of matrices of trancript-level abundances,
counts, lengths produced by \code{\link{tximport}},
with a \code{countsFromAbundance} element that tells
how the counts were generated.}

\item{...}{additional arguments, ignored}

\item{tx2gene}{see \code{\link{tximport}}}

\item{varReduce}{see \code{\link{tximport}}}

\item{ignoreTxVersion}{see \code{\link{tximport}}}

\item{ignoreAfterBar}{see \code{\link{tximport}}}

\item{countsFromAbundance}{see \code{\link{tximport}}}
}
\value{
a list of matrices of gene-level abundances, counts, lengths,
(and inferential replicates or variance if inferential replicates
are present).
}
\description{
Summarizes abundances, counts, lengths, (and inferential
replicates or variance) from transcript- to gene-level.
}
\seealso{
\code{\link{tximport}}
}
