% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_growing_graph.R
\name{add_growing_graph}
\alias{add_growing_graph}
\title{Create a random growing graph with m edges added per step}
\usage{
add_growing_graph(
  graph,
  n,
  m = 1,
  citation = FALSE,
  type = NULL,
  label = TRUE,
  rel = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL,
  set_seed = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{n}{The number of nodes comprising the generated graph.}

\item{m}{The number of edges added per time step.}

\item{citation}{A logical value (default is \code{FALSE}) that governs whether a
citation graph is to be created. This is where new edges specifically
originate from the newly added node in the most recent time step.}

\item{type}{An optional string that describes the entity type for all the
nodes to be added.}

\item{label}{A logical value where setting to \code{TRUE} ascribes node IDs to the
label and \code{FALSE} yields a blank label.}

\item{rel}{An optional string for providing a relationship label to all edges
to be added.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}

\item{set_seed}{Supplying a value sets a random seed of the
\code{Mersenne-Twister} implementation.}
}
\description{
To an existing graph object, add a graph built by adding \code{m} new edges at
each time step (where a node is added).
}
\examples{
# Create a random, growing
# citation graph with 100
# nodes, adding an edge after
# each node addition
growing_graph <-
  create_graph() \%>\%
  add_growing_graph(
    n = 100,
    m = 1,
    citation = TRUE,
    set_seed = 23)

# Get a count of nodes
growing_graph \%>\% count_nodes()

# Get a count of edges
growing_graph \%>\% count_edges()

}
