% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_changepoint.R
\name{autoplot.cpt}
\alias{autoplot.cpt}
\title{Autoplot \code{changepoint::cpt}}
\usage{
\method{autoplot}{cpt}(
  object,
  is.date = NULL,
  cpt.colour = "#FF0000",
  cpt.linetype = "dashed",
  ...
)
}
\arguments{
\item{object}{\code{changepoint::cpt} instance}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12.}

\item{cpt.colour}{Line colour for changepoints}

\item{cpt.linetype}{Line type for changepoints}

\item{...}{other arguments passed \code{autoplot.ts}}
}
\value{
ggplot
}
\description{
Autoplot \code{changepoint::cpt}
}
\examples{
\dontrun{
library(changepoint)
autoplot(cpt.mean(AirPassengers))
autoplot(cpt.meanvar(AirPassengers))
}
}
