% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_labels.R
\name{zap_labels}
\alias{zap_labels}
\title{Zap labels}
\usage{
zap_labels(x)
}
\arguments{
\item{x}{A vector or data frame}
}
\description{
Removes labels, leaving unlabelled vectors as is. Use this if you want to
simply drop all labelling from a data frame. Zapping labels from
\code{\link{labelled_spss}} also removes user-defined missing values,
replacing all with \code{NA}s.
}
\examples{
x1 <- labelled(1:5, c(good = 1, bad = 5))
x1
zap_labels(x1)

x2 <- labelled_spss(c(1:4, 9), c(good = 1, bad = 5), na_values = 9)
x2
zap_labels(x2)

# zap_labels also works with data frames
df <- tibble::data_frame(x1, x2)
df
zap_labels(df)
}
\seealso{
Other zappers: \code{\link{zap_empty}},
  \code{\link{zap_formats}}, \code{\link{zap_widths}}
}
