% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{rcrisk}
\alias{rcrisk}
\alias{cause.pchazard.sim}
\alias{rcrisks}
\title{Simulation of Piecewise constant hazard models with two causes (Cox).}
\usage{
rcrisk(cumhaz1, cumhaz2, rr1, rr2, n = NULL, cens = NULL, rrc = NULL, ...)
}
\arguments{
\item{cumhaz1}{cumulative hazard of cause 1}

\item{cumhaz2}{cumulative hazard of cause 1}

\item{rr1}{number of simulations or vector of relative risk for simuations.}

\item{rr2}{number of simulations or vector of relative risk for simuations.}

\item{n}{number of simulation if rr not given}

\item{cens}{to censor further , rate or cumumlative hazard}

\item{rrc}{retlativ risk for censoring.}

\item{...}{arguments for rchaz}
}
\description{
Simulates data from piecwise constant baseline hazard that can also be of
Cox type. Censor data at highest value of the break points for either of the
cumulatives.
}
\examples{
library(mets); data(bmt); library(survival)

cox1 <- phreg(Surv(time,cause==1)~tcell+platelet,data=bmt)
cox2 <- phreg(Surv(time,cause==2)~tcell+platelet,data=bmt)

X1 <- bmt[,c("tcell","platelet")]
n <- 100
xid <- sample(1:nrow(X1),n,replace=TRUE)
Z1 <- X1[xid,]
Z2 <- X1[xid,]
rr1 <- exp(as.matrix(Z1) \%*\% cox1$coef)
rr2 <- exp(as.matrix(Z2) \%*\% cox2$coef)

d <-  rcrisk(cox1$cum,cox2$cum,rr1,rr2)
dd <- cbind(d,Z1)

scox1 <- phreg(Surv(time,status==1)~tcell+platelet,data=dd)
scox2 <- phreg(Surv(time,status==2)~tcell+platelet,data=dd)
par(mfrow=c(1,2))
plot(cox1); plot(scox1,add=TRUE)
plot(cox2); plot(scox2,add=TRUE)
cbind(cox1$coef,scox1$coef,cox2$coef,scox2$coef)

}
\author{
Thomas Scheike
}
\keyword{survival}
