% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.skip.R
\name{list.skipWhile}
\alias{list.skipWhile}
\title{Keep skipping elements while a condition holds}
\usage{
list.skipWhile(.data, cond)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{cond}{A logical lambda expression}
}
\description{
Keep skipping elements in a list or vector while a
condition holds for the element. As long as the condition
is violated, the element will be kept and all remaining
elements are returned.
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.skipWhile(x, type=='A')
list.skipWhile(x, min(score$c1,score$c2) >= 8)
}
\seealso{
\code{\link{list.skip}}, \code{\link{list.take}},
\code{\link{list.takeWhile}}
}
