# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Ade.idl.

use strict;

package Raritan::RPC::pdumodel::Ade;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "pdumodel.Ade:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::pdumodel::Ade::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::pdumodel::Ade::MetaData;

sub getMetaData($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getMetaData', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::pdumodel::Ade::MetaData::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::pdumodel::Ade::Sample;

sub getLatestSample($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLatestSample', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::pdumodel::Ade::Sample::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}


sub getCalibrationData($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getCalibrationData', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = $rsp->{'_ret_'}->[$i0]->{'value'};
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}


sub setCalibrationData($$) {
    my ($self, $regs) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'regs'} = [];
    foreach my $key0 (keys %{$regs}) {
        my $value0 = $regs->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = "$key0";
        $elem0->{'value'} = 1 * $value0;
        push(@{$args->{'regs'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setCalibrationData', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('pdumodel.Ade', 1, 0, 0, 'Raritan::RPC::pdumodel::Ade');
1;
