
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Computational Engine                                                  *
 *                                                                        *
 *  Copyright (c) 1999-2014, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

#include "subcomplex/npillowtwosphere.h"
#include "triangulation/ntriangle.h"

namespace regina {

NPillowTwoSphere* NPillowTwoSphere::clone() const {
    NPillowTwoSphere* ans = new NPillowTwoSphere();
    ans->triangle[0] = triangle[0];
    ans->triangle[1] = triangle[1];
    ans->triMapping = triMapping;
    return ans;
}

NPillowTwoSphere* NPillowTwoSphere::formsPillowTwoSphere(
        NTriangle* tri1, NTriangle* tri2) {
    if (tri1 == tri2 || tri1->isBoundary() || tri2->isBoundary())
        return 0;
    NEdge* edge[2][3];
    int i;
    for (i = 0; i < 3; i++) {
        edge[0][i] = tri1->getEdge(i);
        edge[1][i] = tri2->getEdge(i);
    }
    if (edge[0][0] == edge[0][1] || edge[0][0] == edge[0][2] ||
            edge[0][1] == edge[0][2])
        return 0;

    // The first triangle has three distinct edges.  See if it matches to the
    // second triangle.
    int joinTo0 = -1;
    for (i = 0; i < 3; i++)
        if (edge[0][0] == edge[1][i]) {
            joinTo0 = i;
            break;
        }
    if (joinTo0 == -1)
        return 0;

    // Now make sure the edges all match up and with the correct
    // permutations.
    NPerm4 perm = tri2->getEdgeMapping(joinTo0) *
        tri1->getEdgeMapping(0).inverse();
    for (i = 1; i < 3; i++) {
        if (edge[0][i] != edge[1][perm[i]])
            return 0;
        if (! (tri2->getEdgeMapping(perm[i]) ==
                perm * tri1->getEdgeMapping(i)))
            return 0;
    }

    // We have an answer.
    NPillowTwoSphere* ans = new NPillowTwoSphere();
    ans->triangle[0] = tri1;
    ans->triangle[1] = tri2;
    ans->triMapping = perm;
    return ans;
}

} // namespace regina

