#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  const Float epsilon = 0.01;
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  Xh.block ("left");
  Xh.block ("right");
  string eta_approx = "P" + itos(Xh.degree()-1) + "d";
  space Qh (omega, eta_approx);
  field eta_h (Qh);
  eta_h ["east"] = 1;
  eta_h ["west"] = epsilon;
  trial u (Xh); test v (Xh);
  form  a  = integrate (eta_h*dot(grad(u),grad(v)));
  field lh = integrate (v);
  field uh (Xh);
  uh["left"] = uh["right"] = 0;
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << catchmark("epsilon") << epsilon << endl
       << catchmark("u")       << uh;
}
