# Copyright (c) 2015 RIPE NCC
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from ripe.atlas.sagan import Result
from ripe.atlas.sagan.ping import PingResult, Packet


def test_ping_0():
    result = Result.get('{"avg":"58.042","dst_addr":"62.2.16.12","dup":"0","fw":0,"max":"58.272","min":"57.876","msm_id":1000192,"prb_id":677,"rcvd":"3","sent":"3","src_addr":"78.128.9.202","timestamp":1328019792,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 58.042)
    assert(result.rtt_median is None)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name is None)
    assert(result.duplicates == 0)
    assert(result.origin is None)
    assert(result.firmware == 0)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 58.272)
    assert(result.rtt_min == 57.876)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 677)
    assert(result.protocol is None)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size is None)
    assert(result.step is None)
    assert(result.created.isoformat() == "2012-01-31T14:23:12+00:00")
    assert(result.packets == [])


def test_ping_1():
    result = Result.get('{"addr":"62.2.16.12","avg":124.572,"dup":0,"from":"194.85.27.7","fw":1,"max":125.44499999999999,"min":123.89400000000001,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":165,"rcvd":3,"sent":3,"size":56,"timestamp":1340523908,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 124.572)
    assert(result.rtt_median is None)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "194.85.27.7")
    assert(result.firmware == 1)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 125.445)
    assert(result.rtt_min == 123.894)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 165)
    assert(result.protocol is None)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size is None)
    assert(result.step is None)
    assert(result.created.isoformat() == "2012-06-24T07:45:08+00:00")
    assert(result.packets == [])


def test_ping_4460():
    result = Result.get('{"addr":"62.2.16.12","af":4,"avg":48.388333333333328,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"188.194.234.136","fw":4460,"max":56.948999999999998,"min":43.869999999999997,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":270,"proto":"ICMP","rcvd":3,"result":[{"rtt":43.869999999999997},{"rtt":56.948999999999998},{"rtt":44.345999999999997}],"sent":3,"size":20,"src_addr":"192.168.178.21","timestamp":1340524626,"ttl":52,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 48.388)
    assert(result.rtt_median == 44.346)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "188.194.234.136")
    assert(result.firmware == 4460)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 56.949)
    assert(result.rtt_min == 43.87)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 270)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step is None)
    assert(result.created.isoformat() == "2012-06-24T07:57:06+00:00")
    assert(result.packets[0].rtt == 43.87)
    assert(result.packets[1].rtt == 56.949)
    assert(result.packets[2].rtt == 44.346)
    assert(result.packets[0].ttl == 52)
    assert(result.packets[1].ttl == 52)
    assert(result.packets[2].ttl == 52)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.178.21")
    assert(result.packets[1].source_address == "192.168.178.21")
    assert(result.packets[2].source_address == "192.168.178.21")


def test_ping_4470():
    result = Result.get('{"addr":"62.2.16.12","af":4,"avg":195.649,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"194.85.27.7","fw":4470,"max":197.79300000000001,"min":193.059,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":165,"proto":"ICMP","rcvd":3,"result":[{"rtt":196.095},{"rtt":197.79300000000001},{"rtt":193.059}],"sent":3,"size":20,"src_addr":"192.168.3.8","timestamp":1344514151,"ttl":46,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 195.649)
    assert(result.rtt_median == 196.095)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "194.85.27.7")
    assert(result.firmware == 4470)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 197.793)
    assert(result.rtt_min == 193.059)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 165)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step is None)
    assert(result.created.isoformat() == "2012-08-09T12:09:11+00:00")
    assert(result.packets[0].rtt == 196.095)
    assert(result.packets[1].rtt == 197.793)
    assert(result.packets[2].rtt == 193.059)
    assert(result.packets[0].ttl == 46)
    assert(result.packets[1].ttl == 46)
    assert(result.packets[2].ttl == 46)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.3.8")
    assert(result.packets[1].source_address == "192.168.3.8")
    assert(result.packets[2].source_address == "192.168.3.8")


def test_ping_4480():
    result = Result.get('{"addr":"62.2.16.12","af":4,"avg":95.756666666666661,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"194.85.27.7","fw":4480,"max":96.147999999999996,"min":95.388999999999996,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":165,"proto":"ICMP","rcvd":3,"result":[{"rtt":95.733000000000004},{"rtt":96.147999999999996},{"rtt":95.388999999999996}],"sent":3,"size":20,"src_addr":"192.168.3.8","timestamp":1349776268,"ttl":46,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 95.757)
    assert(result.rtt_median == 95.733)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "194.85.27.7")
    assert(result.firmware == 4480)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 96.148)
    assert(result.rtt_min == 95.389)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 165)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step is None)
    assert(result.created.isoformat() == "2012-10-09T09:51:08+00:00")
    assert(result.packets[0].rtt == 95.733)
    assert(result.packets[1].rtt == 96.148)
    assert(result.packets[2].rtt == 95.389)
    assert(result.packets[0].ttl == 46)
    assert(result.packets[1].ttl == 46)
    assert(result.packets[2].ttl == 46)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.3.8")
    assert(result.packets[1].source_address == "192.168.3.8")
    assert(result.packets[2].source_address == "192.168.3.8")


def test_ping_4500():
    result = Result.get('{"addr":"62.2.16.12","af":4,"avg":30.114666666666665,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"80.56.151.3","fw":4500,"max":30.344999999999999,"min":29.960999999999999,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":202,"proto":"ICMP","rcvd":3,"result":[{"rtt":30.038},{"rtt":29.960999999999999},{"rtt":30.344999999999999}],"sent":3,"size":20,"src_addr":"192.168.1.229","timestamp":1361244431,"ttl":55,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 30.115)
    assert(result.rtt_median == 30.038)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "80.56.151.3")
    assert(result.firmware == 4500)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 30.345)
    assert(result.rtt_min == 29.961)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 202)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step is None)
    assert(result.created.isoformat() == "2013-02-19T03:27:11+00:00")
    assert(result.packets[0].rtt == 30.038)
    assert(result.packets[1].rtt == 29.961)
    assert(result.packets[2].rtt == 30.345)
    assert(result.packets[0].ttl == 55)
    assert(result.packets[1].ttl == 55)
    assert(result.packets[2].ttl == 55)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.1.229")
    assert(result.packets[1].source_address == "192.168.1.229")
    assert(result.packets[2].source_address == "192.168.1.229")


def test_ping_4520():
    result = Result.get('{"addr":"62.2.16.12","af":4,"avg":67.420999999999992,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"194.85.27.7","fw":4520,"max":70.230999999999995,"min":65.974999999999994,"msm_id":1000192,"name":"hsi.cablecom.ch","prb_id":165,"proto":"ICMP","rcvd":3,"result":[{"rtt":70.230999999999995},{"rtt":65.974999999999994},{"rtt":66.057000000000002}],"sent":3,"size":20,"src_addr":"192.168.3.8","timestamp":1365379380,"ttl":47,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 67.421)
    assert(result.rtt_median == 66.057)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "194.85.27.7")
    assert(result.firmware == 4520)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 70.231)
    assert(result.rtt_min == 65.975)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 165)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step is None)
    assert(result.created.isoformat() == "2013-04-08T00:03:00+00:00")
    assert(result.packets[0].rtt == 70.231)
    assert(result.packets[1].rtt == 65.975)
    assert(result.packets[2].rtt == 66.057)
    assert(result.packets[0].ttl == 47)
    assert(result.packets[1].ttl == 47)
    assert(result.packets[2].ttl == 47)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.3.8")
    assert(result.packets[1].source_address == "192.168.3.8")
    assert(result.packets[2].source_address == "192.168.3.8")


def test_ping_4550():
    result = Result.get('{"af":4,"avg":27.300999999999998,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"80.56.151.3","fw":4550,"lts":365,"max":27.300999999999998,"min":27.300999999999998,"msm_id":1000192,"msm_name":"Ping","prb_id":202,"proto":"ICMP","rcvd":1,"result":[{"srcaddr":"192.168.1.229","x":"*"},{"x":"*"},{"rtt":27.300999999999998,"ttl":54}],"sent":3,"size":20,"src_addr":"192.168.1.229","step":360,"timestamp":1378271710,"ttl":54,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 27.301)
    assert(result.rtt_median == 27.301)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "80.56.151.3")
    assert(result.firmware == 4550)
    assert(result.seconds_since_sync == 365)
    assert(result.rtt_max == 27.301)
    assert(result.rtt_min == 27.301)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 202)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 1)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2013-09-04T05:15:10+00:00")
    assert(result.packets[0].rtt is None)
    assert(result.packets[1].rtt is None)
    assert(result.packets[2].rtt == 27.301)
    assert(result.packets[0].ttl is None)
    assert(result.packets[1].ttl is None)
    assert(result.packets[2].ttl == 54)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.1.229")
    assert(result.packets[1].source_address == "192.168.1.229")
    assert(result.packets[2].source_address == "192.168.1.229")


def test_ping_4560():
    result = Result.get('{"af":4,"avg":36.887,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"62.195.143.53","fw":4560,"lts":36,"max":40.234000000000002,"min":34.747999999999998,"msm_id":1000192,"msm_name":"Ping","prb_id":202,"proto":"ICMP","rcvd":3,"result":[{"rtt":40.234000000000002},{"rtt":34.747999999999998,"srcaddr":"192.168.1.229"},{"rtt":35.679000000000002,"srcaddr":"192.168.1.229"}],"sent":3,"size":20,"src_addr":"192.168.1.229","step":360,"timestamp":1380586151,"ttl":54,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 36.887)
    assert(result.rtt_median == 35.679)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "62.195.143.53")
    assert(result.firmware == 4560)
    assert(result.seconds_since_sync is 36)
    assert(result.rtt_max == 40.234)
    assert(result.rtt_min == 34.748)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 202)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2013-10-01T00:09:11+00:00")
    assert(result.packets[0].rtt == 40.234)
    assert(result.packets[1].rtt == 34.748)
    assert(result.packets[2].rtt == 35.679)
    assert(result.packets[0].ttl == 54)
    assert(result.packets[1].ttl == 54)
    assert(result.packets[2].ttl == 54)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.1.229")
    assert(result.packets[1].source_address == "192.168.1.229")
    assert(result.packets[2].source_address == "192.168.1.229")


def test_ping_4570():
    result = Result.get('{"af":4,"avg":36.608333333333327,"dst_addr":"62.2.16.12","dst_name":"hsi.cablecom.ch","dup":0,"from":"62.195.143.53","fw":4570,"lts":-1,"max":36.741,"min":36.423999999999999,"msm_id":1000192,"msm_name":"Ping","prb_id":202,"proto":"ICMP","rcvd":3,"result":[{"rtt":36.741},{"rtt":36.659999999999997},{"rtt":36.423999999999999}],"sent":3,"size":12,"step":360,"timestamp":1384500425, "type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 36.608)
    assert(result.rtt_median == 36.66)
    assert(result.destination_address == "62.2.16.12")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "62.195.143.53")
    assert(result.firmware == 4570)
    assert(result.seconds_since_sync is None)
    assert(result.rtt_max == 36.741)
    assert(result.rtt_min == 36.424)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 202)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2013-11-15T07:27:05+00:00")
    assert(result.packets[0].rtt == 36.741)
    assert(result.packets[1].rtt == 36.66)
    assert(result.packets[2].rtt == 36.424)
    assert(result.packets[0].ttl is None)
    assert(result.packets[1].ttl is None)
    assert(result.packets[2].ttl is None)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address is None)
    assert(result.packets[1].source_address is None)
    assert(result.packets[2].source_address is None)


def test_ping_4600():
    result = Result.get('{"af":4,"avg":47.951999999999998,"dst_addr":"62.2.16.24","dst_name":"hsi.cablecom.ch","dup":0,"from":"188.195.183.141","fw":4600,"group_id":1000192,"lts":222,"max":48.990000000000002,"min":45.939,"msm_id":1000192,"msm_name":"Ping","prb_id":270,"proto":"ICMP","rcvd":3,"result":[{"rtt":45.939},{"rtt":48.927},{"rtt":48.990000000000002}],"sent":3,"size":12,"src_addr":"192.168.178.21","step":360,"timestamp":1392321470,"ttl":50,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 47.952)
    assert(result.rtt_median == 48.927)
    assert(result.destination_address == "62.2.16.24")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "188.195.183.141")
    assert(result.firmware == 4600)
    assert(result.seconds_since_sync == 222)
    assert(result.rtt_max == 48.99)
    assert(result.rtt_min == 45.939)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 270)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2014-02-13T19:57:50+00:00")
    assert(result.packets[0].rtt == 45.939)
    assert(result.packets[1].rtt == 48.927)
    assert(result.packets[2].rtt == 48.99)
    assert(result.packets[0].ttl == 50)
    assert(result.packets[1].ttl == 50)
    assert(result.packets[2].ttl == 50)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.178.21")
    assert(result.packets[1].source_address == "192.168.178.21")
    assert(result.packets[2].source_address == "192.168.178.21")


def test_ping_4610():
    result = Result.get('{"af":4,"avg":57.140666666666668,"dst_addr":"62.2.16.24","dst_name":"hsi.cablecom.ch","dup":0,"from":"188.195.181.120","fw":4610,"group_id":1000192,"lts":93,"max":63.213000000000001,"min":47.941000000000003,"msm_id":1000192,"msm_name":"Ping","prb_id":270,"proto":"ICMP","rcvd":3,"result":[{"rtt":63.213000000000001},{"rtt":47.941000000000003,"ttl":51},{"rtt":60.268000000000001,"ttl":50}],"sent":3,"size":12,"src_addr":"192.168.178.21","step":360,"timestamp":1395416383,"ttl":50,"type":"ping"}')
    assert(isinstance(result, Result))
    assert(isinstance(result, PingResult))
    assert(isinstance(result.packets[0], Packet))
    assert(isinstance(result.packets[1], Packet))
    assert(isinstance(result.packets[2], Packet))
    assert(result.af == 4)
    assert(result.rtt_average == 57.141)
    assert(result.rtt_median == 60.268)
    assert(result.destination_address == "62.2.16.24")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 0)
    assert(result.origin == "188.195.181.120")
    assert(result.firmware == 4610)
    assert(result.seconds_since_sync == 93)
    assert(result.rtt_max == 63.213)
    assert(result.rtt_min == 47.941)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 270)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 3)
    assert(result.packets_sent == 3)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2014-03-21T15:39:43+00:00")
    assert(result.packets[0].rtt == 63.213)
    assert(result.packets[1].rtt == 47.941)
    assert(result.packets[2].rtt == 60.268)
    assert(result.packets[0].ttl == 50)
    assert(result.packets[1].ttl == 51)
    assert(result.packets[2].ttl == 50)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is False)
    assert(result.packets[2].dup is False)
    assert(result.packets[0].source_address == "192.168.178.21")
    assert(result.packets[1].source_address == "192.168.178.21")
    assert(result.packets[2].source_address == "192.168.178.21")


def test_ping_duplicate():
    result = Result.get('{"af":4,"avg":27.768000000000001,"dst_addr":"62.2.16.24","dst_name":"hsi.cablecom.ch","dup":2,"from":"109.190.83.40","fw":4610,"lts":38,"max":27.768000000000001,"min":27.768000000000001,"msm_id":1000192,"msm_name":"Ping","prb_id":1216,"proto":"ICMP","rcvd":1,"result":[{"srcaddr":"192.168.103.130","x":"*"},{"dup":1,"rtt":36.454000000000001,"ttl":54},{"dup":1,"rtt":37.756},{"rtt":27.768000000000001}],"sent":2,"size":12,"src_addr":"192.168.103.130","step":360,"timestamp":1395277728,"ttl":54,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average == 27.768)
    assert(result.rtt_median == 27.768)
    assert(result.destination_address == "62.2.16.24")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 2)
    assert(result.origin == "109.190.83.40")
    assert(result.firmware == 4610)
    assert(result.seconds_since_sync == 38)
    assert(result.rtt_max == 27.768)
    assert(result.rtt_min == 27.768)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 1216)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 1)
    assert(result.packets_sent == 2)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    assert(result.created.isoformat() == "2014-03-20T01:08:48+00:00")
    assert(result.packets[0].rtt is None)
    assert(result.packets[1].rtt == 36.454)
    assert(result.packets[2].rtt == 37.756)
    assert(result.packets[3].rtt == 27.768)
    assert(result.packets[0].ttl is None)
    assert(result.packets[1].ttl == 54)
    assert(result.packets[2].ttl == 54)
    assert(result.packets[3].ttl == 54)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is True)
    assert(result.packets[2].dup is True)
    assert(result.packets[3].dup is False)
    assert(result.packets[0].source_address == "192.168.103.130")
    assert(result.packets[1].source_address == "192.168.103.130")
    assert(result.packets[2].source_address == "192.168.103.130")
    assert(result.packets[3].source_address == "192.168.103.130")


def test_ping_buggy():
    result = Result.get('{"af":4,"avg":-1,"dst_addr":"62.2.16.24","dst_name":"hsi.cablecom.ch","dup":2,"from":"62.195.143.53","fw":4600,"lts":130,"max":-1,"min":-1,"msm_id":1000192,"msm_name":"Ping","prb_id":202,"proto":"ICMP","rcvd":0,"result":[{"srcaddr":"192.168.1.229","x":"*"},{"dup":1,"rtt":1635.423,"ttl":55},{"dup":1,"rtt":1800.4939999999999}],"sent":1,"size":12,"src_addr":"192.168.1.229","step":360,"timestamp":1394745831,"ttl":55,"type":"ping"}')
    assert(result.af == 4)
    assert(result.rtt_average is None)
    assert(result.rtt_median is None)
    assert(result.destination_address == "62.2.16.24")
    assert(result.destination_name == "hsi.cablecom.ch")
    assert(result.duplicates == 2)
    assert(result.origin == "62.195.143.53")
    assert(result.firmware == 4600)
    assert(result.seconds_since_sync == 130)
    assert(result.rtt_max is None)
    assert(result.rtt_min is None)
    assert(result.measurement_id == 1000192)
    assert(result.probe_id == 202)
    assert(result.protocol == PingResult.PROTOCOL_ICMP)
    assert(result.packets_received == 0)
    assert(result.packets_sent == 1)
    assert(result.packet_size == 12)
    assert(result.step == 360)
    print(result.created, type(result.created))
    print(result.created.isoformat())
    assert(result.created.isoformat() == "2014-03-13T21:23:51+00:00")
    assert(result.packets[0].rtt is None)
    assert(result.packets[1].rtt == 1635.423)
    assert(result.packets[2].rtt == 1800.494)
    assert(result.packets[0].ttl is None)
    assert(result.packets[1].ttl == 55)
    assert(result.packets[2].ttl == 55)
    assert(result.packets[0].dup is False)
    assert(result.packets[1].dup is True)
    assert(result.packets[2].dup is True)
    assert(result.packets[0].source_address == "192.168.1.229")
    assert(result.packets[1].source_address == "192.168.1.229")
    assert(result.packets[2].source_address == "192.168.1.229")


def test_ping_lts():
    result = Result.get('{"af":4,"prb_id":270,"result":[{"rtt":70.265},{"rtt":54.584,"ttl":51},{"rtt":52.875}],"ttl":51,"avg":59.2413333333,"size":12,"from":"188.193.157.75","proto":"ICMP","timestamp":1406561624,"dup":0,"type":"ping","sent":3,"msm_id":1000192,"fw":4650,"max":70.265,"step":360,"src_addr":"192.168.178.21","rcvd":3,"msm_name":"Ping","lts":76,"dst_name":"hsi.cablecom.ch","min":52.875,"group_id":1000192,"dst_addr":"62.2.16.24"}')
    assert(result.seconds_since_sync == 76)
