// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// APIGateway api gateway
//
// swagger:model api.Gateway
type APIGateway struct {

	// Not used now - we could potentially flag gateways that are planned
	// to undergo maintenance mode some time in advance.
	// We can also automatically flag as not healthy gateways that appear
	// not to be routing to the internet.
	Healthy bool `json:"healthy,omitempty"`

	// Host is a unique identifier for the gateway host. It does not need to resolve, since
	// we're not using DNS to resolve the gateways.
	Host string `json:"host,omitempty"`

	// IP6Addr is the IPv6 address
	Ip6Addr string `json:"ip6_addr,omitempty"`

	// IPAddr is the IPv4 address
	IPAddr string `json:"ip_addr,omitempty"`

	// Load is the fractional load received from the menshen agent. For the
	// time being it only makes
	Load float64 `json:"load,omitempty"`

	// Location is the canonical label for the location of the gateway.
	Location string `json:"location,omitempty"`

	// Overloaded should be set to true if the fractional load is above threshold.
	Overloaded bool `json:"overloaded,omitempty"`

	// The (primary) port this gateway is listening on.
	Port int64 `json:"port,omitempty"`

	// TCP, UDP or KCP. This was called "protocol" in previous versions of the API.
	Transport string `json:"transport,omitempty"`

	// Type is the type of gateway. The only valid type as of 2023 is openvpn.
	Type string `json:"type,omitempty"`
}

// Validate validates this api gateway
func (m *APIGateway) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this api gateway based on context it is used
func (m *APIGateway) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *APIGateway) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIGateway) UnmarshalBinary(b []byte) error {
	var res APIGateway
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
