/*
 * s51dude - A Downloader/Uploader for 8051 device programmers
 * Copyright (C) 2008 Lucas Chiesa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "s51dude.h"
#include "parts.h"
//#include "usbtiny.h"

#ifdef WIN32
#include <windows.h>
#define sleep(seconds)      Sleep(seconds * 1000) /* from mingw.org list */
#define usleep(useconds)    Sleep(useconds / 1000)
//El de windows:
//Sleep (1000) Espera 1 segundo
//Sleep (10000) Espera 10 segundo

//El de linux:
//sleep (1)  Espera 1 segundo
//sleep (10) Espera 10 segundos
//usleep (1000) Espera 1ms
//usleep (1) Espera 1us
#endif

void load_dev (char *dest)
{
	int i;

	options.target = NULL;
    for (i=0; i<cant_micros;i++) {
        if (!strcmp(target_list[i]->text_micro,dest)) {
            options.target = target_list[i];
        }
    }
}

// Funciones para grabar y leer lock bits.
void wlb_s52 (int lb1, int lb2, int lb3)
{
	unsigned char res[4];
	wlc[0] = 0xAC;
	if (lb1 || lb3) {
		wlc[1] = 0xE1;
		if (!dry_run_flag) usbtiny_trasnparent_spi(wlc,res);
		sleep(0.3);
	}
	if (lb2 || lb3) {
		wlc[1] = 0xE2;
		if (!dry_run_flag) usbtiny_trasnparent_spi(wlc,res);
		sleep(0.3);
	}
	if (lb3) {
		wlc[1] = 0xE3;
		if (!dry_run_flag) usbtiny_trasnparent_spi(wlc,res);
		sleep(0.3);
	}
}

void wlb_s8253 (int lb1, int lb2, int lb3)
{
	unsigned char res[4];
	wlc[0] = 0xAC;
	wlc[1] = 0xE7;
	wlc[1] &=~ (unsigned char) ( (lb1)+(lb2<<1)+(lb3<<2) );
	if (!dry_run_flag && (lb1||lb2||lb3)) usbtiny_trasnparent_spi(wlc,res);
	sleep(0.3);
}


void wlb_s8252 (int lb1, int lb2, int lb3)
{
	unsigned char res[4];
	wlc[1] = 0xAC;
	wlc[2] = 0x07;
	wlc[2] |= (unsigned char)((lb1<<7)+(lb2<<6)+(lb3<<5));
	if (!dry_run_flag && (lb1||lb2||lb3)) usbtiny_trasnparent_spi(wlc,res);
	sleep(0.3);
}

void rlb_s52 (void)
{
	unsigned char res[4];
	wlc[0] = 0x24;
	if (!dry_run_flag) usbtiny_trasnparent_spi(wlc,res);
	lockbit1_flag = (res[3] & 0x04);
	lockbit2_flag = (res[3] & 0x08);
	lockbit3_flag = (res[3] & 0x10);
}

void rlb_s8253 (void)
{
	unsigned char res[4];
	wlc[0] = 0x24;
	if (!dry_run_flag) usbtiny_trasnparent_spi(wlc,res);
	lockbit1_flag =! (res[3] & 0x01);
	lockbit2_flag =! (res[3] & 0x02);
	lockbit3_flag =! (res[3] & 0x04);
}

