#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:25:22 
# kerberos-connect-kdc.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYDNS="$1"
MYKDC="$2"
#echo "dns=${MYDNS}"
#echo "kdc=${MYKDC}"

### I N C L U D E

. ./_include.sh

### S T A R T

function resolve()
{
	python -c "import socket;socket.gethostbyname(\"$1\")" 2> /dev/null
	return $?
}

function resolveDns()
{
	output=`host "$1" 2> /dev/null | grep -v '^;;' | grep -v 'not found'`
	if [ "${output}" != "" ];then
		echo ${output}
		return 0
	fi
	return 1
}

echo "+ping kdc ${MYKDC}"
ping -q -c 1 ${MYKDC} > /dev/null
if [ "$?" == "0" ]; then
	echo "ok"
	exit 0
else
	ping -q -c 1 ${MYKDC} > /dev/null
	echo "kdc ${MYKDC} cannot be pinged (firewall may drop pings)" >&2
	# fall through
fi

echo "+resolve kdc ${MYKDC} through dns"
resolveDns ${MYKDC}
if [ "$?" != "0" ]; then
	echo "dns cannot resolve kdc ${MYKDC} (may be resolved through other mechanism)" >&2
else
	echo "ok"	
fi

echo "+resolve kdc ${MYKDC} to ip"
resolve ${MYKDC}
if [ "$?" != "0" ]; then
	echo "unresolved kdc ${MYKDC}" >&2
	exit 1
else
	echo "ok"	
fi

exit 0
