// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __framergbtruecolor_h__
#define __framergbtruecolor_h__

#include "framergb.h"
#include "frametrue.h"

class FrameRGBTrueColor : public virtual FrameBase, public FrameRGB, public FrameTrue {
 protected:
  long* colormapData[3];     // preextract data

 private:
  void buildXImage(XImage*, Coord::InternalSystem);

 public:
  FrameRGBTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~FrameRGBTrueColor();

  void colormapCmd(float, float, float, float, float, float, int,
		   unsigned char*, int);
  void colormapBeginCmd();
  void colormapEndCmd();
  void colormapMotionCmd(float, float, float, float, float, float, int,
			 unsigned char*, int);
};

#endif
