/*
 * slmon
 *
 * Copyright (C) 2000, 2001, 2002 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 * $Date: 2003/06/07 18:08:18 $
 * $Revision: 1.1.1.1 $
 *
 */

#include "signal_handling.h"
#include "defines.h"

/*
 * Things that need to be done before exiting
 */

void cleanup(int sig)
{
    SLtt_set_cursor_visibility(1);
    SLang_reset_tty();
    SLsmg_reset_smg();
    glibtop_close();
    exit(sig);
}

/*
 * Signal handlers initialistion
 */

void init_signals(void)
{
    SLsignal(SIGWINCH, handleSIGWINCH);
    SLsignal(SIGKILL, cleanup);
    SLsignal(SIGINT, cleanup);
    SLsignal(SIGQUIT, cleanup);
    SLsignal(SIGSTOP, cleanup);
    SLsignal(SIGTERM, cleanup);
    SLsignal(SIGSEGV, cleanup);
}

/*
 * SIGWINCH handler: resize the display
 */

void handleSIGWINCH(int signal)
{
    extern int redraw;

    SLsig_block_signals();
    SLtt_get_terminfo();
    SLsmg_reset_smg();
    SLsmg_init_smg();
    SLtt_get_screen_size();
    SLsmg_cls();

    redraw = 1;
    pos = 0;
    height = SLtt_Screen_Rows;
    draw_status();
    clear_histogram();
    SLsmg_refresh();
    SLsig_unblock_signals();
    SLsignal_intr(SIGWINCH, handleSIGWINCH);
}
