DEFAULT=/etc/default/spamass-milter

DAEMON=/usr/sbin/spamass-milter
SOCKET="${RUNTIME_DIRECTORY:-/var/run/spamass}"/spamass.sock
PIDFILE="${RUNTIME_DIRECTORY:-/var/run/spamass}"/spamass.pid

RUNAS="spamass-milter"
OPTIONS="-u spamass-milter -i 127.0.0.1"
SOCKETMODE="0600"
SOCKETOWNER="root:root"

# If /usr/sbin/postfix exists, set up the defaults for a postfix install
# These can be overridden in /etc/default/spamass-milter
if [ -x /usr/sbin/postfix ]; then
    SOCKET="/var/spool/postfix/spamass/spamass.sock"
    SOCKETOWNER="spamass-milter:postfix"
    SOCKETMODE="0660"
fi;

if [ -r $DEFAULT ]; then
    . $DEFAULT;
fi;

if [ -z "$SOCKETGROUP" ]; then
    SOCKETGROUP="$(echo "$SOCKETOWNER"|cut -d: -f2)"
    # check to make sure that we can chgrp the socket appropriately
    if ! id -G -n -z "$RUNAS" | grep -qz "$SOCKETGROUP"; then
        echo "In order to change the group of the socket, $RUNAS needs to be part of $SOCKETGROUP."
        echo "Run sudo adduser '$RUNAS' '$SOCKETGROUP'; or the equivalent to fix this and restart spamass-milter."
        exit 1
    fi;
fi;
