'\"
'\" Copyright (c) 1994 The Australian National University
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au),
'\"	    Department of Computer Science,
'\"	    Australian National University.
'\"
.TH photo n 4.0 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
photo \- Full-color images
.SH SYNOPSIS
.nf
\fBimage create photo \fR?\fIname\fR? ?\fIoptions\fR?

\fIimageName \fBblank\fR
\fIimageName \fBcget \fIoption\fR
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
\fIimageName \fBcopy \fIsourceImage\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBdata\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBget \fIx y\fR ?\fIoption\fR?
\fIimageName \fBput \fIdata\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBread \fIfilename\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBredither\fR
\fIimageName \fBtransparency \fIsubcommand \fR?\fIarg ...\fR?
\fIimageName \fBwrite \fIfilename\fR ?\fIoption value(s) ...\fR?
.fi
.BE
.SH DESCRIPTION
.PP
A photo is an image whose pixels can display any color with a varying
degree of transparency (the alpha channel). A photo image is stored
internally in full color (32 bits per pixel), and is displayed using
dithering if necessary.  Image data for a photo image can be obtained
from a file or a string, or it can be supplied from C code through a
procedural interface.  At present, only
.VS 8.6
PNG,
.VE 8.6
GIF, PPM/PGM,
.VS 9.0
and (read-only) SVG
.VE 9.0
formats are supported, but an interface exists to
allow additional image file formats to be added easily.  A photo image
is (semi)transparent if the image data it was obtained from had
transparency information. In regions where no image data has been
supplied, it is fully transparent. Transparency may also be modified
with the \fBtransparency set\fR subcommand.
.SH "CREATING PHOTOS"
.PP
Like all images, photos are created using the \fBimage create\fR
command.
Photos support the following \fIoptions\fR:
.\" OPTION: -data
.TP
\fB\-data \fIstring\fR
.
Specifies the contents of the image as a string.
.VS 9.0
The string should
contain data in the default list-of-lists form,
.VE 9.0
binary data or, for some formats, base64-encoded data (this is
currently guaranteed to be supported for PNG and GIF images). The
format of the string must be one of those for which there is an image
file format handler that will accept string data.  If both the
\fB\-data\fR and \fB\-file\fR options are specified, the \fB\-file\fR
option takes precedence.
.\" OPTION: -format
.TP
\fB\-format\fR {\fIformat-name\fR ?\fIoption value ...\fR?}
.
Specifies the name of the file format for the data specified with the
\fB\-data\fR or \fB\-file\fR option and optional arguments passed to
the format handler. Note that the value of this option must be a Tcl list.
This means that the braces may be omitted if the argument has only one
word. Also, instead of braces, double quotes may be used for quoting.
.\" OPTION: -file
.TP
\fB\-file \fIname\fR
.
\fIname\fR gives the name of a file that is to be read to supply data
for the photo image.  The file format must be one of those for which
there is an image file format handler that can read data.
.\" OPTION: -gamma
.TP
\fB\-gamma \fIvalue\fR
.
Specifies that the colors allocated for displaying this image in a
window should be corrected for a non-linear display with the specified
gamma exponent value.  (The intensity produced by most
CRT displays is a power function of the input value, to a good
approximation; gamma is the exponent and is typically around 2).
The value specified must be greater than zero.  The default
value is one (no correction).  In general, values greater than one
will make the image lighter, and values less than one will make it
darker.
.\" OPTION: -height
.TP
\fB\-height \fInumber\fR
.
Specifies the height of the image, in pixels.  This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink vertically to fit the data stored in it.
.VS 9.0
.\" OPTION: -metadata
.TP
\fB\-metadata \fImetadata\fR
.
Set the metadata dictionary of the image.
Additional keys may be set within the metadata dictionary of the image,
if image data is processed due to a \fB\-file\fR or \fB\-data\fR options
and the driver outputs any metadata keys.
See section \fBMETADATA DICTIONARY\fR below.
.VE 9.0
.\" OPTION: -palette
.TP
\fB\-palette \fIpalette-spec\fR
.
Specifies the resolution of the color cube to be allocated for
displaying this image, and thus the number of colors used from the
colormaps of the windows where it is displayed.  The
\fIpalette-spec\fR string may be either a single decimal number,
specifying the number of shades of gray to use, or three decimal
numbers separated by slashes (/), specifying the number of shades of
red, green and blue to use, respectively.  If the first form (a single
number) is used, the image will be displayed in monochrome (i.e.,
grayscale).
.\" OPTION: -width
.TP
\fB\-width \fInumber\fR
.
Specifies the width of the image, in pixels.    This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink horizontally to fit the data stored in it.
.SH "IMAGE COMMAND"
.PP
When a photo image is created, Tk also creates a new command
whose name is the same as the image.
This command may be used to invoke various operations
on the image.
It has the following general form:
.CS
\fIimageName option \fR?\fIarg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
Those options that write data to the image generally expand the size
of the image, if necessary, to accommodate the data written to the
image, unless the user has specified non-zero values for the
\fB\-width\fR and/or \fB\-height\fR configuration options, in which
case the width and/or height, respectively, of the image will not be
changed.
.PP
The following commands are possible for photo images:
.\" METHOD: blank
.TP
\fIimageName \fBblank\fR
.
Blank the image; that is, set the entire image to have no data, so it
will be displayed as transparent, and the background of whatever
window it is displayed in will show through. The metadata dict of the
image is not changed.
.\" METHOD: cget
.TP
\fIimageName \fBcget\fI option\fR
.
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBimage create\fR \fBphoto\fR command.
.\" METHOD: configure
.TP
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
.
Query or modify the configuration options for the image.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the
\fBimage create\fR \fBphoto\fR command.
.VS 9.0
Note that setting the \fB\-metadata\fR option without any other option
will not invoke the image format driver to recreate the bitmap.
.VE 9.0
.\" METHOD: copy
.TP
\fIimageName \fBcopy\fI sourceImage\fR ?\fIoption value(s) ...\fR?
.
Copies a region from the image called \fIsourceImage\fR (which must
be a photo image) to the image called \fIimageName\fR, possibly with
pixel zooming and/or subsampling.  If no options are specified, this
command copies the whole of \fIsourceImage\fR into \fIimageName\fR,
starting at coordinates (0,0) in \fIimageName\fR.  The following
options may be specified:
.RS
.\" OPTION: -from
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the source image to be copied.
(\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite corners of
the rectangle.  If \fIx2\fR and \fIy2\fR are not specified, the
default value is the bottom-right corner of the source image.  The
pixels copied will include the left and top edges of the specified
rectangle but not the bottom or right edges.  If the \fB\-from\fR
option is not given, the default is the whole source image.
.\" OPTION: -to
.TP
\fB\-to \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the destination image to be
affected.  (\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite
corners of the rectangle.  If \fIx2\fR and \fIy2\fR are not specified,
the default value is (\fIx1,y1\fR) plus the size of the source
region (after subsampling and zooming, if specified).  If \fIx2\fR and
\fIy2\fR are specified, the source region will be replicated if
necessary to fill the destination region in a tiled fashion.
.\" OPTION: -shrink
.TP
\fB\-shrink\fR
.
Specifies that the size of the destination image should be reduced, if
necessary, so that the region being copied into is at the bottom-right
corner of the image.  This option will not affect the width or height
of the image if the user has specified a non-zero value for the
\fB\-width\fR or \fB\-height\fR configuration option, respectively.
.\" OPTION: -zoom
.TP
\fB\-zoom \fIx y\fR
.
Specifies that the source region should be magnified by a factor of
\fIx\fR in the X direction and \fIy\fR in the Y direction.  If \fIy\fR
is not given, the default value is the same as \fIx\fR.  With this
option, each pixel in the source image will be expanded into a block
of \fIx\fR x \fIy\fR pixels in the destination image, all the same
color.  \fIx\fR and \fIy\fR must be greater than 0.
.\" OPTION: -subsample
.TP
\fB\-subsample \fIx y\fR
.
Specifies that the source image should be reduced in size by using
only every \fIx\fRth pixel in the X direction and \fIy\fRth pixel in
the Y direction.  Negative values will cause the image to be flipped
about the Y or X axes, respectively.  If \fIy\fR is not given, the
default value is the same as \fIx\fR.
.\" OPTION: -compositingrule
.TP
\fB\-compositingrule \fIrule\fR
.
Specifies how transparent pixels in the source image are combined with
the destination image.  When a compositing rule of \fIoverlay\fR is
set, the old contents of the destination image are visible, as if the
source image were printed on a piece of transparent film and placed
over the top of the destination.  When a compositing rule of \fIset\fR
is set, the old contents of the destination image are discarded and
the source image is used as-is.  The default compositing rule is
\fIoverlay\fR.
.RE
.\" METHOD: data
.TP
\fIimageName \fBdata\fR ?\fIoption value(s) ...\fR?
.
Returns image data in the form of a string.
.VS 9.0
The format of the string depends on the format handler. By default, a
human readable format as a list of lists of pixel data is used, other
formats can be chosen with the \fB\-format\fR option.
See \fBIMAGE FORMATS\fR below for details.
.VE 9.0
The following options may be specified:
.RS
.\" OPTION: -background
.TP
\fB\-background\fI color\fR
.
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.\" OPTION: -format
.TP
\fB\-format\fR {\fIformat-name\fR ?\fIoption value ...\fR?}
.
Specifies the name of the image file format handler to use and,
optionally, arguments to the format handler.  Specifically, this
subcommand searches for the first handler whose name matches an
initial substring of \fIformat-name\fR and which has the capability to
write a string containing this image data.
.VS 9.0
If this option is not given, this subcommand uses the default format
that consists of a list (one element per row) of lists (one element
per pixel/column) of colors in
.QW \fB#\fIrrggbb\fR
format (see \fBIMAGE FORMATS\fR below).
.VE 9.0
Note that the value of this option must be a Tcl list.
This means that the braces may be omitted if the argument has only one
word. Also, instead of braces, double quotes may be used for quoting.
.\" OPTION: -from
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular region of \fIimageName\fR to be returned.
If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region, including x1,y1
and excluding x2,y2.  The default, if this option is not given, is the
whole image.
.\" OPTION: -grayscale
.TP
\fB\-grayscale\fR
.
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.VS 9.0
.\" OPTION: -metadata
.TP
\fB\-metadata\fI metadata\fR
.
Image format handler may use metadata to be included in the returned
data string.
The specified \fImetadata\fR is passed to the driver for inclusion in the
data.
If no \fB\-metadata\fR option is given, the current metadata of the
image is used.
.VE 9.0
.RE
.\" METHOD: get
.TP
\fIimageName \fBget\fI x y\fR ?\fB\-withalpha\fR?
.
Returns the color of the pixel at coordinates (\fIx\fR,\fIy\fR) in the
image as a list of three integers between 0 and 255, representing the
red, green and blue components respectively. If the \fB\-withalpha\fR
option is specified, the returned list will have a fourth element
representing the alpha value of the pixel as an integer between 0 and
255.
.\" METHOD: put
.TP
\fIimageName \fBput\fI data\fR ?\fIoption value(s) ...\fR?
.
Sets pixels in \fI imageName\fR to the data specified in \fIdata\fR.
.VS 9.0
This command searches the list of image file format handlers for
a handler that can interpret the data in \fIdata\fR, and then reads
the image encoded within into \fIimageName\fR (the destination image).
See \fBIMAGE FORMATS\fR below for details on formats for image data.
.VE 9.0
The following options may be specified:
.RS
.\" OPTION: -format
.TP
\fB\-format\fR {\fIformat-name\fR ?\fIoption value ..\fR?}
.
Specifies the format of the image data in \fIdata\fR and, optionally,
arguments to be passed to the format handler.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
Note that the value of this option must be a Tcl list.
This means that the braces may be omitted if the argument has only one
word. Also, instead of braces, double quotes may be used for quoting.
.VS 9.0
.\" OPTION: -metadata
.TP
\fB\-metadata\fI metadata\fR
.
A specified \fImetadata\fR is passed to the image format driver when interpreting
the data.
Note that the current metadata of the image is not passed to the format driver
and is not changed by the command.
.VE 9.0
.\" OPTION: -to
.TP
\fB\-to \fIx1 y1\fR ?\fIx2 y2\fR?
.
Specifies the coordinates of the top-left corner (\fIx1\fR,\fIy1\fR)
of the region of \fIimageName\fR into which the image data will be
copied.  The default position is (0,0).  If \fIx2\fR,\fIy2\fR is given
and \fIdata\fR is not large enough to cover the rectangle specified by
this option, the image data extracted will be tiled so it covers the
entire destination rectangle. If the region specified with this option
is smaller than the supplied \fIdata\fR, the exceeding data is silently
discarded. Note that if \fIdata\fR specifies a
single color value, then a region extending to the bottom-right corner
represented by (\fIx2\fR,\fIy2\fR) will be filled with that color.
.RE
.\" METHOD: read
.TP
\fIimageName \fBread\fI filename\fR ?\fIoption value(s) ...\fR?
.
Reads image data from the file named \fIfilename\fR into the image.
This command first searches the list of
image file format handlers for a handler that can interpret the data
in \fIfilename\fR, and then reads the image in \fIfilename\fR into
\fIimageName\fR (the destination image).  The following options may be
specified:
.RS
.\" OPTION: -format
.TP
\fB\-format {\fIformat-name\fR ?\fIoption value ..\fR?}
.
Specifies the format of the image data in \fIfilename\fR and,
optionally, additional options to the format handler.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
Note that the value of this option must be a Tcl list.
This means that the braces may be omitted if the argument has only one
word. Also, instead of braces, double quotes may be used for quoting.
.\" OPTION: -from
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the image file data to be copied
to the destination image.  If only \fIx1\fR and \fIy1\fR are
specified, the region extends from (\fIx1,y1\fR) to the bottom-right
corner of the image in the image file.  If all four coordinates are
specified, they specify diagonally opposite corners or the region.
The default, if this option is not specified, is the whole of the
image in the image file.
.VS 9.0
.\" OPTION: -metadata
.TP
\fB\-metadata\fI metadata\fR
.
A specified \fImetadata\fR is passed to the image format driver when interpreting
the data.
Note that the current metadata of the image is not passed to the format driver
and is not changed by the command.
.VE 9.0
.\" OPTION: -shrink
.TP
\fB\-shrink\fR
.
If this option, the size of \fIimageName\fR will be reduced, if
necessary, so that the region into which the image file data are read
is at the bottom-right corner of the \fIimageName\fR.  This option
will not affect the width or height of the image if the user has
specified a non-zero value for the \fB\-width\fR or \fB\-height\fR
configuration option, respectively.
.\" OPTION: -to
.TP
\fB\-to \fIx y\fR
.
Specifies the coordinates of the top-left corner of the region of
\fIimageName\fR into which data from \fIfilename\fR are to be read.
The default is (0,0).
.RE
.\" METHOD: redither
.TP
\fIimageName \fBredither\fR
.
The dithering algorithm used in displaying photo images propagates
quantization errors from one pixel to its neighbors.
If the image data for \fIimageName\fR is supplied in pieces, the
dithered image may not be exactly correct.  Normally the difference is
not noticeable, but if it is a problem, this command can be used to
recalculate the dithered image in each window where the image is
displayed.
.\" METHOD: transparency
.TP
\fIimageName \fBtransparency \fIsubcommand \fR?\fIarg ...\fR?
.
Allows examination and manipulation of the transparency information in
the photo image.  Several subcommands are available:
.RS
.TP
\fIimageName \fBtransparency get \fIx y\fR ?\fB\-alpha\fR?
.VS 9.0
Returns true if the pixel at (\fIx\fR,\fIy\fR) is fully transparent,
false otherwise.  If the option \fB\-alpha\fR is passed, returns the
alpha value of the pixel instead, as an integer in the range 0 to 255.
.VE 9.0
.TP
\fIimageName \fBtransparency set \fIx y newVal\fR ?\fB\-alpha\fR?
.VS 9.0
Change the transparency of the pixel at (\fIx\fR,\fIy\fR) to
\fInewVal.\fR If no additional option is passed, \fInewVal\fR is
interpreted as a boolean and the pixel is made fully transparent if
that value is true, fully opaque otherwise.  If the \fB\-alpha\fR
option is passed, \fInewVal\fR is interpreted as an integral alpha
value for the pixel, which must be in the range 0 to 255.
.VE 9.0
.RE
.\" METHOD: write
.TP
\fIimageName \fBwrite \fIfilename\fR ?\fIoption value(s) ...\fR?
.
Writes image data from \fIimageName\fR to a file named \fIfilename\fR.
The following options may be specified:
.RS
.\" OPTION: -background
.TP
\fB\-background\fI color\fR
.
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.\" OPTION: -format
.TP
\fB\-format\fR {\fIformat-name\fR ?\fIoption value ...\fR?}
.
Specifies the name of the image file format handler to be used to
write the data to the file and, optionally, options to pass to the
format handler.  Specifically, this subcommand searches for the first
handler whose name matches an initial substring of \fIformat-name\fR
and which has the capability to write an image file.  If this option
is not given, the format is guessed from the file extension. If that
cannot be determined, this subcommand uses the first handler that has
the capability to write an image file.
Note that the value of this option must be a Tcl list.
This means that the braces may be omitted if the argument has only one
word. Also, instead of braces, double quotes may be used for quoting.
.\" OPTION: -from
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular region of \fIimageName\fR to be written to the
image file.  If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region.  The default,
if this option is not given, is the whole image.
.\" OPTION: -grayscale
.TP
\fB\-grayscale\fR
.
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.VS 9.0
.\" OPTION: -metadata
.TP
\fB\-metadata\fI metadata\fR
.
Image format handler may use metadata to be included in the written file.
The specified \fImetadata\fR is passed to the driver for inclusion in the
file.
If no \fB\-metadata\fR option is given, the current metadata of the
image is used.
.VE 9.0
.RE
.SH "IMAGE FORMATS"
.PP
The photo image code is structured to allow handlers for additional
image file formats to be added easily.  The photo image code maintains
a list of these handlers.  Handlers are added to the list by
registering them with a call to \fBTk_CreatePhotoImageFormat\fR.  The
standard Tk distribution comes with handlers for PPM/PGM, PNG, GIF and
(read-only) SVG formats,
.VS 9.0
as well as the \fBdefault\fR handler to encode/decode image
data in a human readable form.
.VE 9.0
These handlers are automatically registered on initialization.
.PP
When reading an image file or processing string data specified with
the \fB\-data\fR configuration option, the photo image code invokes
each handler in turn until one is found that claims to be able to read
the data in the file or string.  Usually this will find the correct
handler, but if it does not, the user may give a format name with the
\fB\-format\fR option to specify which handler to use.  In this case,
the photo image code will try those handlers whose names begin with
the string specified for the \fB\-format\fR option (the comparison is
case-insensitive).  For example, if the user specifies \fB\-format
gif\fR, then a handler named GIF87 or GIF89 may be invoked, but a
handler named JPEG may not (assuming that such handlers had been
registered).
.PP
When writing image data to a file, the processing of the
\fB\-format\fR option is slightly different: the string value given
for the \fB\-format\fR option must begin with the complete name of the
requested handler, and may contain additional information following
that, which the handler can use, for example, to specify which variant
to use of the formats supported by the handler.
Note that not all image handlers may support writing transparency data
to a file, even where the target image format does.
.VS 9.0
.SS "THE DEFAULT IMAGE HANDLER"
.PP
The \fBdefault\fR image handler cannot be used to read or write data
from/to a file. Its sole purpose is to encode and decode image data in
string form in a clear text, human readable, form. The \fIimageName\fR
\fBdata\fR subcommand uses this handler when no other format is
specified. When reading image data from a string with \fIimageName\fR
\fBput\fR or the \fB\-data\fR option, the default handler is treated
as the other handlers.
.PP
Image data in the \fBdefault\fR string format is a (top-to-bottom)
list of scan-lines, with each scan-line being a (left-to-right) list
of pixel data. Every scan-line has the same length. The color
and, optionally, alpha value of each pixel is specified in any of
the forms described in the \fBCOLOR FORMATS\fR section below.
.VE 9.0

.SS "FORMAT SUBOPTIONS"
.PP
.VS 8.6
Image formats may support sub-options, which are specified using
additional words in the value to the \fB\-format\fR option. These
suboptions can affect how image data is read or written to file or
string. The nature and values of these options is up to the format
handler.
The built-in handlers support these suboptions:
.\" OPTION -colorformat
.VS 9.0
.TP
\fBdefault \-colorformat\fI formatType\fR
.
The option is allowed when writing image data to a string with
\fIimageName \fBdata\fR. Specifies the format to use for the color
string of each pixel. \fIformatType\fR may be one of: \fBrgb\fR to
encode pixel data in the form \fB#\fIRRGGBB\fR, \fBrgba\fR to encode
pixel data in the form \fB#\fIRRGGBBAA\fR or \fBlist\fR to encode
pixel data as a list with four elements. See \fBCOLOR FORMATS\fR
below for details. The default is \fBrgb\fR.
.VE 9.0
.\" OPTION -index
.TP
\fBgif \-index\fI indexValue\fR
.
The option has effect when reading image data from a file. When
parsing a multi-part GIF image, Tk normally only accesses the first
image. By giving the \fB\-index\fR sub-option, the \fIindexValue\fR'th
value may be used instead. The \fIindexValue\fR must be an integer
from 0 up to the number of image parts in the GIF data.
.\" OPTION -alpha
.TP
\fBpng \-alpha\fI alphaValue\fR
.
The option has effect when reading image data from a file. Specifies
an additional alpha filtering for the overall image, which allows the
background on which the image is displayed to show through.  This
usually also has the effect of desaturating the image.  The
\fIalphaValue\fR must be between 0.0 and 1.0.
.\" OPTION -dpi
.\" OPTION -scale
.\" OPTION -scaletowidth
.\" OPTION -scaletoheight
.TP
\fBsvg \-dpi\fI dpiValue \fB\-scale\fI scaleValue \fB\-scaletowidth\fI width \fB\-scaletoheight\fI height\fR
.
\fIdpiValue\fR is used in conversion between given coordinates and
screen resolution. The value must be greater than 0 and the default
value is 96.
.PP
.RS
\fIscaleValue\fR is used to scale the resulting image. The value must
be greater than 0 and the default value is 1.
\fIwidth\fR and \fIheight\fR are the width or height that the image
will be adjusted to. Only one parameter among \fB\-scale\fR,
\fB\-scaletowidth\fR and \fB\-scaletoheight\fR can be given at a time
and the aspect ratio of the original image is always preserved.
The \fBsvg\fR format supports a wide range of SVG features, but the
full SVG standard is not available, for instance the 'text' feature
is missing and silently ignored when reading the SVG data.
The supported SVG features are:
.TP
\fBelements:\fR
.
g, path, rect, circle, ellipse, line, polyline, polygon,
linearGradient, radialGradient, stop, defs, svg, style
.TP
\fBattributes:\fR
.
width, height, viewBox,
preserveAspectRatio with none, xMin, xMid, xMax, yMin, yMid, yMax, slice
.TP
\fBgradient attributes:\fR
.
gradientUnits with objectBoundingBox,
gradientTransform, cx, cy, r fx, fy x1, y1, x2, y2
spreadMethod with pad, reflect or repeat,
xlink:href
.TP
\fBpoly attributes:\fR
.
points
.TP
\fBline attributes:\fR
.
x1, y1, x2, y2
.TP
\fBellipse attributes:\fR
.
cx, cy, rx, ry
.TP
\fBcircle attributes:\fR
.
cx, cy, r
.TP
\fBrectangle attributes:\fR
.
x, y, width, height, rx, ry
.TP
\fBpath attributes:\fR
.
d with m, M, l, L, h, H, v, V, c, C, s, S, q, Q, t, T, a, A, z, Z
.TP
\fBstyle attributes:\fR
.
display with none, visibility, hidden, visible,
fill with nonzero and evenodd, opacity, fill-opacity,
stroke, stroke-width, stroke-dasharray, stroke-dashoffset, stroke-opacity,
stroke-linecap with butt, round and square,
stroke-linejoin with miter, round and  bevel, stroke-miterlimit
fill-rule, font-size,
transform with matrix, translate, scale, rotate, skewX and  skewY,
stop-color, stop-opacity, offset, id, class
.RE
.PP
.RS
Currently only SVG images reading and conversion into (pixel-based
format) photos is supported: Tk does not (yet) support bundling photo
images in SVG vector graphics.
.RE
.VE 8.6
.VS 9.0
.SH "COLOR FORMATS"
.PP
The default image handler can represent/parse color and alpha values
of a pixel in one of the formats listed below. If a color format does
not contain transparency information, full opacity is assumed.  The
available color formats are:
.IP \(bu 3
The empty string - interpreted as full transparency, the color value
is undefined.
.IP \(bu 3
Any value accepted by \fBTk_GetColor\fR, optionally followed by an
alpha suffix. The alpha suffix may be one of:
.RS
.TP
\fB@\fR\fIA\fR
.
The alpha value \fIA\fR must be a fractional value in the range  0.0
(fully transparent) to 1.0 (fully opaque).
.TP
\fB#\fR\fIX\fR
.
The alpha value \fIX\fR is a hexadecimal digit that specifies an integer
alpha value in the range 0 (fully transparent) to 255 (fully opaque).
This is expanded in range from 4 bits wide to 8 bits wide by
multiplication by 0x11.
.TP
\fB#\fR\fIXX\fR
.
The alpha value \fIXX\fR is passed as two hexadecimal digits that
specify an integer alpha value in the range 0 (fully transparent) to 255
(fully opaque).
.RE
.IP \(bu 3
A Tcl list with three or four integers in the range 0 to 255,
specifying the values for the red, green, blue and (optionally)
alpha channels respectively.
.IP \(bu 3
\fB#\fR\fIRGBA\fR format: a \fB#\fR followed by four hexadecimal digits,
where each digit is the value for the red, green, blue and alpha
channels respectively. Each digit will be expanded internally to
8 bits by multiplication by 0x11.
.IP \(bu 3
\fB#\fR\fIRRGGBBAA\fR format: \fB#\fR followed by eight hexadecimal digits,
where each pair of  subsequent digits represents the value for the red,
green, blue and alpha channels respectively.
.VE 9.0
.SH "COLOR ALLOCATION"
.PP
When a photo image is displayed in a window, the photo image code
allocates colors to use to display the image and dithers the image, if
necessary, to display a reasonable approximation to the image using
the colors that are available.  The colors are allocated as a color
cube, that is, the number of colors allocated is the product of the
number of shades of red, green and blue.
.PP
Normally, the number of
colors allocated is chosen based on the depth of the window.  For
example, in an 8-bit PseudoColor window, the photo image code will
attempt to allocate seven shades of red, seven shades of green and
four shades of blue, for a total of 198 colors.  In a 1-bit StaticGray
(monochrome) window, it will allocate two colors, black and white.  In
a 24-bit DirectColor or TrueColor window, it will allocate 256 shades
each of red, green and blue.  Fortunately, because of the way that
pixel values can be combined in DirectColor and TrueColor windows,
this only requires 256 colors to be allocated.  If not all of the
colors can be allocated, the photo image code reduces the number of
shades of each primary color and tries again.
.PP
The user can exercise some control over the number of colors that a
photo image uses with the \fB\-palette\fR configuration option.  If
this option is used, it specifies the maximum number of shades of
each primary color to try to allocate.  It can also be used to force
the image to be displayed in shades of gray, even on a color display,
by giving a single number rather than three numbers separated by
slashes.
.VS 9.0
.SH "METADATA DICTIONARY"
.PP
Each image has a metadata dictionary property.
This dictionary is not relevant to the bitmap representation of the
image, but may contain additional information like resolution or
comments.
Image format drivers may output metadata when image data is
parsed, or may use metadata to be included in image files or formats.
.SS "METADATA KEYS (MULTIPLE FORMATS)"
.PP
Each image format driver supports an individual set of metadata dictionary
keys. Predefined keys are:
.IP \fBDPI\fR
Horizontal image resolution in DPI as a double value.
Supported by format \fBpng\fR.
.IP \fBaspect\fR
Aspect ratio horizontal divided by vertical as double value.
Supported by formats \fBgif\fR and \fBpng\fR.
.IP \fBcomment\fR
Image text comment.
Supported by formats \fBgif\fR and \fBpng\fR.
.PP
It is valid to set any key in the metadata dict.
A format driver will ignore keys that it does not handle.
.SS "METADATA KEYS FOR ANIMATED GIF INFORMATION"
.PP
The following metadata keys are reported when reading a \fBgif\fR format file.
They are typically used in conjunction with the \fB\-index\fR option of an
animated \fBgif\fR file to properly display the subimage sequence.
The options are linked to each subimage selected by \fB\-index\fR.
.TP
\fBdelay time\fI time\fR
.
Update delay time in 10ms units.
This key is only present if the delay time is not 0.
.TP
\fBdisposal method\fI method\fR
.
Disposal method of the preceeding image, if given for the current image.
Possible values are: \fBdo not dispose\fR, \fBrestore to background color\fR,
\fBrestore to previous\fR.
.TP
\fBuser interaction\fI bool\fR
.
The key is present with a value of 1, if user interaction is specified.
Otherwise, the key is not present.
.TP
\fBupdate region\fI X0\fR, \fIY0\fR, \fIwidth\fR, \fIheight\fR
.
Update region of the current subimage, if subimage has not the same size as
the full image. The pixel outside of this box are all fully transparent.
.PP
.VE 9.0
.SH CREDITS
.PP
The photo image type was designed and implemented by Paul Mackerras,
based on his earlier photo widget and some suggestions from
John Ousterhout.
.SH EXAMPLE
.PP
Load an image from a file and tile it to the size of a window, which
is useful for producing a tiled background:
.PP
.CS
# These lines should be called once
\fBimage create photo\fR untiled -file "theFile.ppm"
\fBimage create photo\fR tiled

# These lines should be called whenever .someWidget changes
# size; a <Configure> binding is useful here
set width  [winfo width .someWidget]
set height [winfo height .someWidget]
tiled \fBcopy\fR untiled -to 0 0 $width $height -shrink
.CE
.PP
.VS 8.6
The PNG image loader allows the application of an additional alpha factor
during loading, which is useful for generating images suitable for disabled
buttons:
.PP
.CS
\fBimage create photo\fR icon -file "icon.png"
\fBimage create photo\fR iconDisabled -file "icon.png" \e
        -format "png -alpha 0.5"
button .b -image icon -disabledimage iconDisabled
.CE
.VE 8.6
.PP
.VS 9.0
Create a green box with a simple shadow effect
.PP
.CS
\fBimage create photo\fR foo

# Make a simple graduated fill varying in alpha for the shadow
for {set i 14} {$i > 0} {incr i -1} {
   set i2 [expr {$i + 30}]
   foo \fBput\fR [format black#%x [expr {15-$i}]] -to $i $i $i2 $i2
}

# Put a solid green rectangle on top
foo \fBput\fR #F080 -to 0 0 30 30
.VE 9.0
.CE
.SH "SEE ALSO"
image(n)
.SH KEYWORDS
photo, image, color
'\" Local Variables:
'\" mode: nroff
'\" End:
