"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This file defines protos that store the results of autotuning various
operations.

They are in proto format because we want to log them structured. They offer
tremendous statistical, testing, and debugging value.
"""
import builtins
import collections.abc
import sys
import typing

import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import tensorflow.tsl.protobuf.dnn_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class CudnnVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAJOR_FIELD_NUMBER: builtins.int
    MINOR_FIELD_NUMBER: builtins.int
    PATCH_FIELD_NUMBER: builtins.int
    major: builtins.int
    minor: builtins.int
    patch: builtins.int
    def __init__(
        self,
        *,
        major: builtins.int | None = ...,
        minor: builtins.int | None = ...,
        patch: builtins.int | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["major", b"major", "minor", b"minor", "patch", b"patch"]) -> None: ...

global___CudnnVersion = CudnnVersion

@typing_extensions.final
class ComputeCapability(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAJOR_FIELD_NUMBER: builtins.int
    MINOR_FIELD_NUMBER: builtins.int
    major: builtins.int
    minor: builtins.int
    def __init__(
        self,
        *,
        major: builtins.int | None = ...,
        minor: builtins.int | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["major", b"major", "minor", b"minor"]) -> None: ...

global___ComputeCapability = ComputeCapability

@typing_extensions.final
class AutotuneResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _FailureKind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FailureKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AutotuneResult._FailureKind.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: AutotuneResult._FailureKind.ValueType  # 0
        REDZONE_MODIFIED: AutotuneResult._FailureKind.ValueType  # 1
        """Algorithm wrote memory outside its output buffers."""
        WRONG_RESULT: AutotuneResult._FailureKind.ValueType  # 2
        """Algorithm gave a different result from a reference algorithm."""
        DISQUALIFIED: AutotuneResult._FailureKind.ValueType  # 3
        """Algorithm was rejected for failing to run or for known bugs."""

    class FailureKind(_FailureKind, metaclass=_FailureKindEnumTypeWrapper): ...
    UNKNOWN: AutotuneResult.FailureKind.ValueType  # 0
    REDZONE_MODIFIED: AutotuneResult.FailureKind.ValueType  # 1
    """Algorithm wrote memory outside its output buffers."""
    WRONG_RESULT: AutotuneResult.FailureKind.ValueType  # 2
    """Algorithm gave a different result from a reference algorithm."""
    DISQUALIFIED: AutotuneResult.FailureKind.ValueType  # 3
    """Algorithm was rejected for failing to run or for known bugs."""

    @typing_extensions.final
    class FailureResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KIND_FIELD_NUMBER: builtins.int
        MSG_FIELD_NUMBER: builtins.int
        REFERENCE_CONV_FIELD_NUMBER: builtins.int
        REFERENCE_GEMM_FIELD_NUMBER: builtins.int
        REFERENCE_CUDA_CONV_PLAN_FIELD_NUMBER: builtins.int
        REFERENCE_ALGORITHM_FIELD_NUMBER: builtins.int
        BUFFER_ADDRESS_FIELD_NUMBER: builtins.int
        kind: global___AutotuneResult.FailureKind.ValueType
        msg: builtins.str
        @property
        def reference_conv(self) -> global___AutotuneResult.ConvKey: ...
        @property
        def reference_gemm(self) -> global___AutotuneResult.GemmKey: ...
        @property
        def reference_cuda_conv_plan(self) -> global___AutotuneResult.CudaConvPlanKey: ...
        @property
        def reference_algorithm(self) -> tensorflow.tsl.protobuf.dnn_pb2.AlgorithmProto: ...
        buffer_address: builtins.int
        def __init__(
            self,
            *,
            kind: global___AutotuneResult.FailureKind.ValueType | None = ...,
            msg: builtins.str | None = ...,
            reference_conv: global___AutotuneResult.ConvKey | None = ...,
            reference_gemm: global___AutotuneResult.GemmKey | None = ...,
            reference_cuda_conv_plan: global___AutotuneResult.CudaConvPlanKey | None = ...,
            reference_algorithm: tensorflow.tsl.protobuf.dnn_pb2.AlgorithmProto | None = ...,
            buffer_address: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["key", b"key", "reference_algorithm", b"reference_algorithm", "reference_conv", b"reference_conv", "reference_cuda_conv_plan", b"reference_cuda_conv_plan", "reference_gemm", b"reference_gemm"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["buffer_address", b"buffer_address", "key", b"key", "kind", b"kind", "msg", b"msg", "reference_algorithm", b"reference_algorithm", "reference_conv", b"reference_conv", "reference_cuda_conv_plan", b"reference_cuda_conv_plan", "reference_gemm", b"reference_gemm"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["key", b"key"]) -> typing_extensions.Literal["reference_conv", "reference_gemm", "reference_cuda_conv_plan", "reference_algorithm"] | None: ...

    @typing_extensions.final
    class ConvKey(google.protobuf.message.Message):
        """Legacy and unused in new data; superseded by AlgorithmProto."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ALGORITHM_FIELD_NUMBER: builtins.int
        TENSOR_OPS_ENABLED_FIELD_NUMBER: builtins.int
        algorithm: builtins.int
        tensor_ops_enabled: builtins.bool
        def __init__(
            self,
            *,
            algorithm: builtins.int | None = ...,
            tensor_ops_enabled: builtins.bool | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "tensor_ops_enabled", b"tensor_ops_enabled"]) -> None: ...

    @typing_extensions.final
    class GemmKey(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ALGORITHM_FIELD_NUMBER: builtins.int
        algorithm: builtins.int
        def __init__(
            self,
            *,
            algorithm: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm"]) -> None: ...

    @typing_extensions.final
    class CudaConvPlanKey(google.protobuf.message.Message):
        """Legacy and unused in new data; superseded by AlgorithmProto."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXEC_PLAN_ID_FIELD_NUMBER: builtins.int
        exec_plan_id: builtins.str
        def __init__(
            self,
            *,
            exec_plan_id: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["exec_plan_id", b"exec_plan_id"]) -> None: ...

    SCRATCH_BYTES_FIELD_NUMBER: builtins.int
    RUN_TIME_FIELD_NUMBER: builtins.int
    FAILURE_FIELD_NUMBER: builtins.int
    CONV_FIELD_NUMBER: builtins.int
    GEMM_FIELD_NUMBER: builtins.int
    CUDA_CONV_PLAN_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    scratch_bytes: builtins.int
    @property
    def run_time(self) -> google.protobuf.duration_pb2.Duration: ...
    @property
    def failure(self) -> global___AutotuneResult.FailureResult: ...
    @property
    def conv(self) -> global___AutotuneResult.ConvKey: ...
    @property
    def gemm(self) -> global___AutotuneResult.GemmKey: ...
    @property
    def cuda_conv_plan(self) -> global___AutotuneResult.CudaConvPlanKey: ...
    @property
    def algorithm(self) -> tensorflow.tsl.protobuf.dnn_pb2.AlgorithmProto: ...
    def __init__(
        self,
        *,
        scratch_bytes: builtins.int | None = ...,
        run_time: google.protobuf.duration_pb2.Duration | None = ...,
        failure: global___AutotuneResult.FailureResult | None = ...,
        conv: global___AutotuneResult.ConvKey | None = ...,
        gemm: global___AutotuneResult.GemmKey | None = ...,
        cuda_conv_plan: global___AutotuneResult.CudaConvPlanKey | None = ...,
        algorithm: tensorflow.tsl.protobuf.dnn_pb2.AlgorithmProto | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "conv", b"conv", "cuda_conv_plan", b"cuda_conv_plan", "failure", b"failure", "gemm", b"gemm", "key", b"key", "run_time", b"run_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["algorithm", b"algorithm", "conv", b"conv", "cuda_conv_plan", b"cuda_conv_plan", "failure", b"failure", "gemm", b"gemm", "key", b"key", "run_time", b"run_time", "scratch_bytes", b"scratch_bytes"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["key", b"key"]) -> typing_extensions.Literal["conv", "gemm", "cuda_conv_plan", "algorithm"] | None: ...

global___AutotuneResult = AutotuneResult

@typing_extensions.final
class AutotuningLog(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTR_FIELD_NUMBER: builtins.int
    RESULTS_FIELD_NUMBER: builtins.int
    CUDNN_VERSION_FIELD_NUMBER: builtins.int
    COMPUTE_CAPABILITY_FIELD_NUMBER: builtins.int
    DEVICE_PCI_BUS_ID_FIELD_NUMBER: builtins.int
    BLAS_VERSION_FIELD_NUMBER: builtins.int
    @property
    def instr(self) -> google.protobuf.any_pb2.Any: ...
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AutotuneResult]:
        """Records all auto-tuning results per algorithm."""
    @property
    def cudnn_version(self) -> global___CudnnVersion: ...
    @property
    def compute_capability(self) -> global___ComputeCapability: ...
    device_pci_bus_id: builtins.str
    """stream_executor::DeviceDescription::pci_bus_id."""
    blas_version: builtins.str
    def __init__(
        self,
        *,
        instr: google.protobuf.any_pb2.Any | None = ...,
        results: collections.abc.Iterable[global___AutotuneResult] | None = ...,
        cudnn_version: global___CudnnVersion | None = ...,
        compute_capability: global___ComputeCapability | None = ...,
        device_pci_bus_id: builtins.str | None = ...,
        blas_version: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["compute_capability", b"compute_capability", "cudnn_version", b"cudnn_version", "instr", b"instr"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["blas_version", b"blas_version", "compute_capability", b"compute_capability", "cudnn_version", b"cudnn_version", "device_pci_bus_id", b"device_pci_bus_id", "instr", b"instr", "results", b"results"]) -> None: ...

global___AutotuningLog = AutotuningLog
