/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "purchaseclient.h"
#include <QDebug>

namespace UbuntuPurchases {

PurchaseClient::PurchaseClient(QQuickItem *parent) :
    QQuickItem(parent)
{
    this->m_client = new PurchaseServiceClient("com.canonical.Purchase", "/", QDBusConnection::sessionBus(), 0);

    QObject::connect(this->m_client, &PurchaseServiceClient::failure, this, &PurchaseClient::purchaseFailed);
    QObject::connect(this->m_client, &PurchaseServiceClient::success, this, &PurchaseClient::purchaseSucceeded);
}

PurchaseClient::~PurchaseClient()
{
    delete this->m_client;
}

void PurchaseClient::purchaseItem(const QVariantMap id)
{
    this->m_client->purchase(id);
}

void PurchaseClient::purchaseFailed(const QString &packageName)
{
    Q_EMIT this->failed(packageName);
}

void PurchaseClient::purchaseSucceeded(const QString &packageName)
{
    Q_EMIT this->succeeded(packageName);
}

}
