/*
 * Copyright (C) 2013,2014 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "displayconfigurationpolicy.h"
#include "logging.h"

#include "mir/graphics/display_configuration.h"
#include "mir/graphics/pixel_format_utils.h"

#include <algorithm>

namespace geom = mir::geometry;
namespace mg = mir::graphics;

DisplayConfigurationPolicy::DisplayConfigurationPolicy(std::shared_ptr<mg::DisplayConfigurationPolicy> const& base_policy, bool with_alpha)
    :   base_policy{base_policy},
        with_alpha{with_alpha}
{
}

void DisplayConfigurationPolicy::apply_to(mg::DisplayConfiguration& conf)
{
    DLOG("DisplayConfigurationPolicy::apply_to (this=%p, conf=%p)", this, &conf);

    base_policy->apply_to(conf);
    conf.for_each_output(
        [&](mg::UserDisplayConfigurationOutput& conf_output)
        {
            if (!conf_output.connected || !conf_output.used) return;

            auto const& format = find_if(conf_output.pixel_formats.begin(),
                                         conf_output.pixel_formats.end(),
                                         [&](MirPixelFormat format) -> bool
                                             {
                                                 return mg::contains_alpha(format) == with_alpha;
                                             }
                                        );

            // keep the default settings if nothing was found
            if (format == conf_output.pixel_formats.end())
                return;
            
            conf_output.current_format = *format;
        });
}
