// SPDX-FileCopyrightText: 2006 Istituto Nazionale di Fisica Nucleare
//
// SPDX-License-Identifier: Apache-2.0

package org.italiangrid.voms.error;

/**
 * VOMS validation error codes.
 * 
 * @author Andrea Ceccanti
 *
 */
public enum VOMSValidationErrorCode {

  // Temporal validity
  acNotValidAtCurrentTime,

  // LSC signature checks
  lscFileNotFound, emptyAcCertsExtension, lscDescriptionDoesntMatchAcCert, invalidAcCert, acCertFailsSignatureVerification,

  // Local AA cert signature checks
  aaCertNotFound, invalidAaCert, aaCertFailsSignatureVerification,

  // Holder checks
  acHolderDoesntMatchCertChain,

  // Targets checks
  localhostDoesntMatchAcTarget,

  // CAnL errors
  canlError,

  // Other
  other;
}
