/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import rene.gui.ButtonAction;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.util.MyVector;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class SelectDialog
extends HelpCloseDialog
implements ActionListener {
    MyVector V;
    ConstructionObject O = null;
    Lister L;

    public SelectDialog(Frame frame, MyVector myVector) {
        super(frame, Zirkel.name("select.title", "Select Object"), true);
        this.V = myVector;
        this.L = new Lister();
        this.add("Center", this.L);
        this.L.setMode(false, false, false, false);
        for (int i = 0; i < myVector.size(); ++i) {
            ConstructionObject constructionObject = (ConstructionObject)myVector.elementAt(i);
            if (constructionObject instanceof PointObject) {
                this.L.addElement(constructionObject.getName(), Color.black);
                continue;
            }
            if (constructionObject instanceof PrimitiveLineObject) {
                this.L.addElement(constructionObject.getName(), Color.red.darker());
                continue;
            }
            if (constructionObject instanceof PrimitiveCircleObject) {
                this.L.addElement(constructionObject.getName(), Color.blue.darker());
                continue;
            }
            this.L.addElement(constructionObject.getName(), Color.green.darker());
        }
        this.L.select(0);
        this.L.addActionListener(this);
        this.L.updateDisplay();
        MyPanel myPanel = new MyPanel();
        myPanel.add(new ButtonAction(this, Zirkel.name("select.ok"), "OK"));
        myPanel.add(new ButtonAction(this, Zirkel.name("select.cancel"), "Close"));
        this.addHelp(myPanel, "mouse");
        this.add("South", new Panel3D(myPanel));
        this.pack();
        this.center(frame);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.L) {
            this.doAction("OK");
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void doAction(String string) {
        this.Aborted = true;
        if (string.equals("OK")) {
            int n = this.L.getSelectedIndex();
            if (n >= 0) {
                this.O = (ConstructionObject)this.V.elementAt(n);
            }
            this.Aborted = false;
            this.doclose();
        } else {
            super.doAction(string);
        }
    }

    public ConstructionObject getObject() {
        return this.O;
    }
}

