/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SubstreamInstruction
extends Instruction
implements IStreamOptimizationInstruction {
    protected Instruction m_source;
    protected Instruction m_start;
    protected Instruction m_length;
    protected boolean m_zeroBased;

    public SubstreamInstruction() {
    }

    public SubstreamInstruction(Instruction instruction, Instruction instruction2, Instruction instruction3, boolean bl) {
        this.m_source = instruction;
        this.m_start = instruction2;
        this.m_length = instruction3;
        this.m_zeroBased = bl;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_length == null ? 2 : 3;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        if (this.m_length != null) {
            if (n == 0) {
                return this.m_length;
            }
            --n;
        }
        switch (n) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_start;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        if (this.m_length != null) {
            if (n == 0) {
                this.m_length = instruction;
                return;
            }
            --n;
        }
        switch (n) {
            case 0: {
                this.m_source = instruction;
                break;
            }
            case 1: {
                this.m_start = instruction;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new SubstreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_start.cloneWithoutTypeInformation(), this.m_length == null ? null : this.m_length.cloneWithoutTypeInformation(), this.m_zeroBased);
    }

    @Override
    public Instruction cloneShallow() {
        return new SubstreamInstruction(this.m_source, this.m_start, this.m_length == null ? null : this.m_length, this.m_zeroBased);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_length != null) {
            typeEnvironment.unify(this.m_length.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        }
        TypeVariable typeVariable = new TypeVariable();
        Type type = this.setCachedType(this.m_source.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
        typeEnvironment.unify(type, typeVariable.getStreamType(), this);
        typeEnvironment.unify(this.m_start.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        return type;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_source.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = codeGenerationTracker.generateConventionally(this.m_source, dataFlowCodeGenerationHelper);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this.m_source);
        String string3 = "(" + codeGenerationTracker.generateConventionally(this.m_start, dataFlowCodeGenerationHelper) + (this.m_zeroBased ? ")" : " - 1)");
        String string4 = this.m_length == null ? string2 + ".length - " + string3 : codeGenerationTracker.generateConventionally(this.m_length, dataFlowCodeGenerationHelper);
        String string5 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string5, streamType, "new " + streamType.getElementType().getImplementationName(dataFlowCodeGenerationHelper) + "[" + string4 + "]", codeGenerationTracker);
        dataFlowCodeGenerationHelper.append("System.arraycopy(");
        dataFlowCodeGenerationHelper.append(string2);
        dataFlowCodeGenerationHelper.append(", ");
        dataFlowCodeGenerationHelper.append(string3);
        dataFlowCodeGenerationHelper.append(", ");
        dataFlowCodeGenerationHelper.append(string5);
        dataFlowCodeGenerationHelper.append(", 0, ");
        dataFlowCodeGenerationHelper.append(string4);
        dataFlowCodeGenerationHelper.append(");\n");
        return string5;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        int n;
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this.m_source);
        int n2 = codeGenerationTracker.generateConventionallyIntoRegister(this.m_source, bCELCodeGenerationHelper, instructionListBuilder);
        int n3 = codeGenerationTracker.generateConventionallyIntoRegister(this.m_start, bCELCodeGenerationHelper, instructionListBuilder);
        if (!this.m_zeroBased) {
            instructionListBuilder.appendLocalDecrement(n3);
        }
        if (this.m_length == null) {
            instructionListBuilder.appendALoad(n2);
            instructionListBuilder.appendArrayLength();
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendISub();
            n = codeGenerationTracker.allocateRegister();
            instructionListBuilder.appendIStore(n);
        } else {
            n = codeGenerationTracker.generateConventionallyIntoRegister(this.m_length, bCELCodeGenerationHelper, instructionListBuilder);
        }
        instructionListBuilder.appendILoad(n);
        instructionListBuilder.appendNewArray(streamType.getElementType());
        int n4 = codeGenerationTracker.allocateRegister();
        instructionListBuilder.appendDUP();
        instructionListBuilder.appendAStore(n4);
        instructionListBuilder.appendALoad(n2);
        instructionListBuilder.appendILoad(n3);
        instructionListBuilder.appendALoad(n4);
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendILoad(n);
        instructionListBuilder.appendSystemArrayCopy();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_source = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_source, bindingEnvironment);
        this.m_start = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_start, bindingEnvironment);
        if (this.m_length != null) {
            this.m_length = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_length, bindingEnvironment);
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        IStream iStream = (IStream)this.m_source.evaluate(environment, function, iDebuggerInterceptor, false);
        int n = (Integer)this.m_start.evaluate(environment, function, iDebuggerInterceptor, false);
        int n2 = (Integer)this.m_length.evaluate(environment, function, iDebuggerInterceptor, false);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = iStream.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n3 < n - (this.m_zeroBased ? 0 : 1)) {
                ++n3;
                continue;
            }
            if (n3 < n + n2) {
                arrayList.add(e);
            }
            ++n3;
        }
        ListStream listStream = new ListStream(arrayList);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, listStream);
    }

    @Override
    public String innerToString() {
        return this.m_zeroBased ? "substream" : "substream-1";
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        String string2 = codeGenerationTracker.generateConventionally(this.m_source, dataFlowCodeGenerationHelper);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this.m_source);
        String string3 = "(" + codeGenerationTracker.generateConventionally(this.m_start, dataFlowCodeGenerationHelper) + (this.m_zeroBased ? ")" : " - 1)");
        String string4 = this.m_length == null ? string2 + ".length - " + string3 : codeGenerationTracker.generateConventionally(this.m_length, dataFlowCodeGenerationHelper);
        StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, string2, string4, string3, -1);
    }

    @Override
    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        int n;
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this.m_source);
        int n2 = codeGenerationTracker.generateConventionallyIntoRegister(this.m_source, bCELCodeGenerationHelper, instructionListBuilder);
        int n3 = codeGenerationTracker.generateConventionallyIntoRegister(this.m_start, bCELCodeGenerationHelper, instructionListBuilder);
        if (!this.m_zeroBased) {
            instructionListBuilder.appendLocalDecrement(n3);
        }
        if (this.m_length == null) {
            instructionListBuilder.appendALoad(n2);
            instructionListBuilder.appendArrayLength();
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendISub();
            n = codeGenerationTracker.allocateRegister();
            instructionListBuilder.appendIStore(n);
        } else {
            n = codeGenerationTracker.generateConventionallyIntoRegister(this.m_length, bCELCodeGenerationHelper, instructionListBuilder);
        }
        StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, codeGenerationTracker, n2, n3, n, -1);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_source = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_start = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_length = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
        this.m_zeroBased = readObjectFileHelper.readBoolean();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_source);
        writeObjectFileHelper.writeInstruction(this.m_start);
        writeObjectFileHelper.writeBoolean(this.m_length != null);
        if (this.m_length != null) {
            writeObjectFileHelper.writeInstruction(this.m_length);
        }
        writeObjectFileHelper.writeBoolean(this.m_zeroBased);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n);
        this.m_source.toString(prettyPrinter, n + 1);
        this.m_start.toString(prettyPrinter, n + 1);
        if (this.m_length != null) {
            this.m_length.toString(prettyPrinter, n + 1);
        }
        prettyPrinter.printFormClose(n);
    }
}

