/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobTracker;

public class ClusterStatus
implements Writable {
    private int numActiveTrackers;
    private Collection<String> activeTrackers = new ArrayList<String>();
    private Collection<String> blacklistedTrackers = new ArrayList<String>();
    private Collection<String> graylistedTrackers = new ArrayList<String>();
    private int numBlacklistedTrackers;
    private int numGraylistedTrackers;
    private int numExcludedNodes;
    private long ttExpiryInterval;
    private int map_tasks;
    private int reduce_tasks;
    private int max_map_tasks;
    private int max_reduce_tasks;
    private JobTracker.State state;
    public static final long UNINITIALIZED_MEMORY_VALUE = -1L;
    private long used_memory = -1L;
    private long max_memory = -1L;

    ClusterStatus() {
    }

    @Deprecated
    ClusterStatus(int trackers, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state) {
        this(trackers, 0, 0, JobTracker.TASKTRACKER_EXPIRY_INTERVAL, maps, reduces, maxMaps, maxReduces, state);
    }

    ClusterStatus(int trackers, int blacklists, int graylists, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state) {
        this(trackers, blacklists, graylists, ttExpiryInterval, maps, reduces, maxMaps, maxReduces, state, 0);
    }

    ClusterStatus(int trackers, int blacklists, int graylists, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state, int numDecommissionedNodes) {
        this(trackers, blacklists, graylists, ttExpiryInterval, maps, reduces, maxMaps, maxReduces, state, numDecommissionedNodes, -1L, -1L);
    }

    ClusterStatus(Collection<String> activeTrackers, Collection<String> blacklistedTrackers, Collection<String> graylistedTrackers, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state) {
        this(activeTrackers, blacklistedTrackers, graylistedTrackers, ttExpiryInterval, maps, reduces, maxMaps, maxReduces, state, 0);
    }

    ClusterStatus(int trackers, int blacklists, int graylists, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state, int numDecommissionedNodes, long used_memory, long max_memory) {
        this.numActiveTrackers = trackers;
        this.numBlacklistedTrackers = blacklists;
        this.numGraylistedTrackers = graylists;
        this.numExcludedNodes = numDecommissionedNodes;
        this.ttExpiryInterval = ttExpiryInterval;
        this.map_tasks = maps;
        this.reduce_tasks = reduces;
        this.max_map_tasks = maxMaps;
        this.max_reduce_tasks = maxReduces;
        this.state = state;
        this.used_memory = used_memory;
        this.max_memory = max_memory;
    }

    ClusterStatus(Collection<String> activeTrackers, Collection<String> blacklistedTrackers, Collection<String> graylistedTrackers, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state, int numDecommissionNodes) {
        this(activeTrackers.size(), blacklistedTrackers.size(), graylistedTrackers.size(), ttExpiryInterval, maps, reduces, maxMaps, maxReduces, state, numDecommissionNodes, Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory());
        this.activeTrackers = activeTrackers;
        this.blacklistedTrackers = blacklistedTrackers;
        this.graylistedTrackers = graylistedTrackers;
    }

    public int getTaskTrackers() {
        return this.numActiveTrackers;
    }

    public Collection<String> getActiveTrackerNames() {
        return this.activeTrackers;
    }

    public Collection<String> getBlacklistedTrackerNames() {
        return this.blacklistedTrackers;
    }

    public int getBlacklistedTrackers() {
        return this.numBlacklistedTrackers;
    }

    public Collection<String> getGraylistedTrackerNames() {
        return this.graylistedTrackers;
    }

    public int getGraylistedTrackers() {
        return this.numGraylistedTrackers;
    }

    public int getNumExcludedNodes() {
        return this.numExcludedNodes;
    }

    public long getTTExpiryInterval() {
        return this.ttExpiryInterval;
    }

    public int getMapTasks() {
        return this.map_tasks;
    }

    public int getReduceTasks() {
        return this.reduce_tasks;
    }

    public int getMaxMapTasks() {
        return this.max_map_tasks;
    }

    public int getMaxReduceTasks() {
        return this.max_reduce_tasks;
    }

    public JobTracker.State getJobTrackerState() {
        return this.state;
    }

    @Deprecated
    public long getUsedMemory() {
        return this.used_memory;
    }

    @Deprecated
    public long getMaxMemory() {
        return this.max_memory;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.activeTrackers.size() == 0) {
            out.writeInt(this.numActiveTrackers);
            out.writeInt(0);
        } else {
            out.writeInt(this.activeTrackers.size());
            out.writeInt(this.activeTrackers.size());
            for (String tracker : this.activeTrackers) {
                Text.writeString(out, tracker);
            }
        }
        if (this.blacklistedTrackers.size() == 0) {
            out.writeInt(this.numBlacklistedTrackers);
            out.writeInt(0);
        } else {
            out.writeInt(this.blacklistedTrackers.size());
            out.writeInt(this.blacklistedTrackers.size());
            for (String tracker : this.blacklistedTrackers) {
                Text.writeString(out, tracker);
            }
        }
        if (this.graylistedTrackers.size() == 0) {
            out.writeInt(this.numGraylistedTrackers);
            out.writeInt(0);
        } else {
            out.writeInt(this.graylistedTrackers.size());
            out.writeInt(this.graylistedTrackers.size());
            for (String tracker : this.graylistedTrackers) {
                Text.writeString(out, tracker);
            }
        }
        out.writeInt(this.numExcludedNodes);
        out.writeLong(this.ttExpiryInterval);
        out.writeInt(this.map_tasks);
        out.writeInt(this.reduce_tasks);
        out.writeInt(this.max_map_tasks);
        out.writeInt(this.max_reduce_tasks);
        out.writeLong(this.used_memory);
        out.writeLong(this.max_memory);
        WritableUtils.writeEnum(out, this.state);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String name;
        int i;
        this.numActiveTrackers = in.readInt();
        int numTrackerNames = in.readInt();
        if (numTrackerNames > 0) {
            for (i = 0; i < numTrackerNames; ++i) {
                name = Text.readString(in);
                this.activeTrackers.add(name);
            }
        }
        this.numBlacklistedTrackers = in.readInt();
        numTrackerNames = in.readInt();
        if (numTrackerNames > 0) {
            for (i = 0; i < numTrackerNames; ++i) {
                name = Text.readString(in);
                this.blacklistedTrackers.add(name);
            }
        }
        this.numGraylistedTrackers = in.readInt();
        numTrackerNames = in.readInt();
        if (numTrackerNames > 0) {
            for (i = 0; i < numTrackerNames; ++i) {
                name = Text.readString(in);
                this.graylistedTrackers.add(name);
            }
        }
        this.numExcludedNodes = in.readInt();
        this.ttExpiryInterval = in.readLong();
        this.map_tasks = in.readInt();
        this.reduce_tasks = in.readInt();
        this.max_map_tasks = in.readInt();
        this.max_reduce_tasks = in.readInt();
        this.used_memory = in.readLong();
        this.max_memory = in.readLong();
        this.state = WritableUtils.readEnum(in, JobTracker.State.class);
    }
}

